<?php

/*
Home Site Maker, the websites factory.
Copyright (C) 2004, 2005 Marcos Martinez Jimenez

This file is part of Home Site Maker.

    Home Site Maker is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Home Site Maker is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Home Site Maker; see the file COPYING. If not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


Marcos Martinez Jimenez
marcos@assl-site.net
http://homesitemaker.no-ip.org
Francesc Llunell n 1 4 5, Esplugues de Llobregat, 08950 Barcelona, Spain
*/


/*
Configuration file for Home Site Maker

 How to edit the config_site.php file ?

 - The [REQUIRED] variables should be modified with your own site values
 - You must to customize the variables identified with the [EDIT] tag
 - The [OPT] ones are optional, and you can leave they untouched
 - The [TRANS] tag is used when the only thing you need to do is to translate the value to your own langauaje
 - Don't edit the variables with the [STOP] comment if you don't know exactly what you are doing
*/


$VERSION="homesitemaker-v0.4.7-1";                     // [STOP] Only for upgrading purporses
$TITLE="Homesite Maker";                             // [EDIT] The title of your website
$DESCRIPTION="The Homesite Maker project home page"; // [EDIT] A brief description of your website
$URL="http://yoursite.org";                          // [REQUIRED] The URL used to serve your site

$SKIN="white_clouds"; // [OPT] Available skins are rainbow, aqua, simple, black-simple, black-grey and white_clouds
$ICONS="white_clouds";// [OPT] Available icon-set is white_clouds
$ICON_SIZE1="32";     // [OPT] Available values are 64, 48, 32 and 22
$ICON_SIZE2="48";     // [OPT] Available values are 64, 48, 32 and 22
$HEADER_WIDTH="90%";  // [OPT] Use porcentual value (%) or in pixels
$BODY_WIDTH="90%";    // [OPT] Use porcentual value (%) or in pixels
$LANGUAGE="english";  // [EDIT] Available languages are english, spanish and catalan.
$EDITOR="FCKeditor";  // [OPT] Availble values are: text-html, FCKeditor or both.
                      // This option allows you to choose between different edition modes when you send news or edit infos.
                      //       text-html: Send as HTML or Text compatible with all browsers but only for geeks visitors.
                      //       FCKeditor: WYSIWYG editor. Usable for everybody, with or without HTML knowledge but, 
                      //                  only compatible with the following browsers:
                      //                  IE 5.5+ (Windows), Firefox 1.0+, Mozilla 1.3+ and Netscape 7+ browsers.
                      //                  Be sure you have the sources of FCKeditor in DocumentRoot/includes/FCKeditor
                      //                  if you install directly from the CVS sources.
                      //                  See www.fckeditor.net to know more about Frederico Caldeira Knabben editor (FCKeditor)
                      //       both: The user can choose between WYSIWYG edition mode or HTML/Text mode.

$RSS_LANG="es";                            // [REQUIRED] Use only ISO 639 codes es, en, de, ca, etc.
$RSS_ENCODING="ISO-8859-1";                //[STOP] If you have problems using UTF-8, use ISO-8859-1 instead
$RSS_HISTORY="10";                         // [OPT] Set the maximun number of news per XML/RSS feed file.
$RSS_EDITOR="editor@something.com";        // [REQUIRED] Email address of person responsible for editorial content.
$RSS_WEBMASTER="webmaster@something.com";  // [REQUIRED] Email address of person responsible for technical issues relating to channel

$DB_USER="homesite_user";                  // [REQUIRED] The MySQL database user
$DB_PASSWD="homesite_passwd";              // [REQUIRED] The MySQL user password
$DB_NAME="homesite_db";                    // [REQUIRED] The MySQL database name

$DEFAULT_TAB="1";     // [OPT] Set the tab that should be on top when no one is selected (default option)
$DEFAULT_SECTION="1"; // [OPT] Set the tab that should be on top when no one is selected (default option)

/* Set the title you wants for the main sections (tabs) and subsections (sections)
   There are 4 section types for the SECTION_TYPE variable.
      info  -> Allows you to edit the content of one static page in a easy way, allowing you to attach images
      news  -> Allows you to send news with attached images and post comments
      album -> A management system for your image albums with full access control system.
      diary -> Not already finished
      NO    -> Hide, no section is showed */

$TAB_1="Home";           // [EDIT] Title for the main section 1 (tab 1)
$TAB_2="Albums";         // [EDIT] Title for the main section 2 (tab 2)
$TAB_3="About";          // [EDIT] Title for the main section 3 (tab 3)
$TAB_4="Help";           // [EDIT] Title for the main section 4 (tab 4)
$TAB_5="Control Panel";  // [TRANS] Title for the control panel (tab 5)

$TAB_11="News";           $SECTION_TYPE_11="news";    // [EDIT][EDIT] Title and type of the section 1 of the tab 1
$TAB_12="Contact";        $SECTION_TYPE_12="info";    // [EDIT][EDIT] Title and type of the section 2 of the tab 1
$TAB_13="Downloads";      $SECTION_TYPE_13="info";    // [EDIT][EDIT] Title and type of the section 3 of the tab 1
$TAB_14="NO";             $SECTION_TYPE_14="NO";      // [EDIT][EDIT] Title and type of the section 4 of the tab 1

$TAB_21="Sports";         $SECTION_TYPE_21="album";   // [EDIT][EDIT] Title and type of the section 1 of the tab 2
$TAB_22="Art Gallery";    $SECTION_TYPE_22="album";   // [EDIT][EDIT] Title and type of the section 2 of the tab2
$TAB_23="NO";             $SECTION_TYPE_23="NO";      // [EDIT][EDIT] Title and type of the section 3 of the tab 2
$TAB_24="NO";             $SECTION_TYPE_24="NO";      // [EDIT][EDIT] Title and type of the section 4 of the tab 2

$TAB_31="Events";         $SECTION_TYPE_31="diary";   // [EDIT][EDIT] Title and type of the section 1 of the tab 3
$TAB_32="Links";          $SECTION_TYPE_32="info";    // [EDIT][EDIT] Title and type of the section 2 of the tab 3
$TAB_33="Site Map";       $SECTION_TYPE_33="info";    // [EDIT][EDIT] Title and type of the section 3 of the tab 3
$TAB_34="NO";             $SECTION_TYPE_34="NO";      // [EDIT][EDIT] Title and type of the section 4 of the tab 3

$TAB_41="FAQs";           $SECTION_TYPE_41="info";    // [EDIT][EDIT] Title and type of the section 1 of the tab 4
$TAB_42="Handbook";       $SECTION_TYPE_42="info";    // [EDIT][EDIT] Title and type of the section 2 of the tab 4
$TAB_43="NO";             $SECTION_TYPE_43="NO";      // [EDIT][EDIT] Title and type of the section 3 of the tab 4
$TAB_44="NO";             $SECTION_TYPE_44="NO";      // [EDIT][EDIT] Title and type of the section 4 of the tab 4

$TAB_51="Users";          $SECTION_TYPE_51="users";   // [TRANS][STOP] Don't touch this if you don't know what you are doing
$TAB_52="Configuration";  $SECTION_TYPE_52="config";  // [TRANS][STOP] Don't touch this if you don't know what you are doing
$TAB_53="Style";          $SECTION_TYPE_53="style";    // [TRANS][STOP] Don't touch this if you don't know what you are doing
$TAB_54="Help";           $SECTION_TYPE_54="help";    // [TRANS][STOP] Don't touch this if you don't know what you are doing

$P_ITEMS="YES";           // [OPT] If you wants to show pending items to be published in the left pannel say yes here.
$STATS="YES";             // [OPT] If you wants to show some stats in the left pannel say yes here.


/* The following tags allows you to put HTML code in every of the six empty boxes of the webpage.
   All of them are optional [OPT] but can be usefull to modify the look and feel of your website.
   As you can see in the example, you can use the HTML <img> tag in order to put an image inside it.
   The COLOR_BOX and SKIN_BOX variables, allows to apply diferrent color (depending on the skin)
   and the skin used to build the box respectively. If you say NO in the SKIN_BOX, then the box will be 
   displayed without borders.

   $SIZE_BOX[n]  To modify the height of the box[n]. Range 1-n (Default 90).
                 If SIZE_BOX[n]=0 the box is not displayed
   $SKIN_BOX[n]  You can use different skins for every box. See the comment $SKIN at the beginning
                 of this file for available skins list.
                 Furthermore you can say "NO" for drawing borderless boxes.
   $COLOR_BOX[n] Depending on the skin you choose, you can select between
                 up to four (B,Y,M,G) different colors for every box.
                 You can use also color codes like #nnnnn. It's useful to integrate
                 special borderless boxes with the background color and SKIN_BOX[n]="NO")
   $LOGO_BOX[n]  Use LOGO_BOX to add content (text or images) into the boxes (HTML tags are allowed) 
                 DON'T FORGET TO ESCAPE THE DOUBLE QUOTES WHEN YOU TYPE HTML CODE!!! */

$SIZE_BOX1="90";
$WIDTH_BOX1="15%";
$SKIN_BOX1="$SKIN";
$COLOR_BOX1="Y";
$LOGO_BOX1="<div class=\"text6\"><center>HomeSite<br>Maker</center></div>";

$SIZE_BOX2="90";
$WIDTH_BOX2="15%";
$SKIN_BOX2="$SKIN";
$COLOR_BOX2="G";
$LOGO_BOX2="";

$SIZE_BOX3="90";
$WIDTH_BOX3="55%";
$SKIN_BOX3="$SKIN";
$COLOR_BOX3="B";
$LOGO_BOX3="";

$SIZE_BOX4="90";
$WIDTH_BOX4="15%";
$SKIN_BOX4="$SKIN";
$COLOR_BOX4="M";
$LOGO_BOX4="";

$SIZE_BOX5="180";
$SKIN_BOX5="$SKIN";
$COLOR_BOX5="B";
$LOGO_BOX5="<center><img src=\"images/logos/homesite_maker.jpg\"></center>";

$SIZE_LEFT_BOX="620";
$SKIN_LEFT_BOX="$SKIN";
$COLOR_LEFT_BOX="Y";

$SIZE_LOGIN_BOX="230";
$SKIN_LOGIN_BOX="$SKIN";
$COLOR_LOGIN_BOX="M";

$SIZE_FOOTER_BOX="55";
$SKIN_FOOTER_BOX="NO";
$COLOR_FOOTER_BOX="G";
$LOGO_FOOTER_BOX="This site is powered by <a href=\"http://homesitemaker.no-ip.org\" target=\"new\">HomeSite Maker</a>".
                 " code. This code is distibuted under <a href=\"http://www.gnu.org/licenses/gpl.html\" target=\"new\">GNU/GPL</a>".
                 " license and are made by melmak from <a href=\"http://www.assl-site.net\" target=\"new\">www.assl-site.net</a>".
                 "<br>All trademarks and copyrights on this page are owned by their respective owners.".
                 "<center>".
                 "<a href=\"http://www.mysql.com\" target=\"new\">".
                 "<img border=0 title=\"Powered by MySQL Database Server\" vspace=1 src=\"images/logos/mysql_powered_white.png\">".
                 "</img></a>&nbsp;&nbsp;&nbsp;&nbsp;".
                 "<a href=\"http://www.php.net\" target=\"new\">".
                 "<img border=0 title=\"Powered by PHP: Hypertext Preprocessor\" vspace=3 src=\"images/logos/php_powered_white.png\"></img></a>".
                 "</center>";

?>
