<?php

/*
Home Site Maker, the websites factory.
Copyright (C) 2004, 2005 Marcos Martinez Jimenez

This file is part of Home Site Maker.

    Home Site Maker is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Home Site Maker is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Home Site Maker; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


Marcos Martinez Jimenez
marcos@assl-site.net
http://homesitemaker.no-ip.org
Francesc Llunell n 1 4 5, Esplugues de Llobregat, 08950 Barcelona, Spain
*/


// FILE NAME:       rss/rss-generator.php
// AUTHOR:          Marcos Martinez Jimenez

include ("includes/languages/".$LANGUAGE."/homesite-rss-rss_generator.php");

// XML Entity Mandatory Escape Characters 
// Thanks to send user contributed note at mail.2aj.net 
// http://es.php.net/manual/en/function.htmlentities.php#54770)

function xmlentities ( $string ){
return str_replace ( array ( '&', '"', "'", '<', '>' ), array ( '&amp;' , '&quot;', '&apos;' , '&lt;' , '&gt;' ), $string );
}

// Parsing config_site.php in order to now the file list to create and delete old ones if needed

for ($tab = 1; $tab <= 4; $tab++ )
    {
    for ($section = 1; $section <= 4; $section++)
        {
        $section_type_str = "SECTION_TYPE_"."$tab"."$section";
        $section_name_str = "TAB_"."$tab"."$section";
        $rss_file = "rss/news"."$tab"."$section".".rss";
        if ($$section_type_str == "news") // For every news section, one rss file is created
           {
           $date=date("D, d M Y H:i:s T");
           $RSS_DESCRIPTION = $TEXT001.$TITLE."(".$$section_name_str.")";
           $headers = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n".
                      "<rss version=\"2.0\">\n".
                      "<channel>\n".
                      "  <title>$TITLE</title>\n".
                      "  <description>$RSS_DESCRIPTION</description>\n".
                      "  <link>$URL</link>\n".
                      "  <lastBuildDate>$date</lastBuildDate>\n".
                      "  <pubDate>$date</pubDate>\n".
                      "  <generator>$VERSION</generator>\n".
                      "  <managingEditor>$RSS_EDITOR</managingEditor>\n".
                      "  <webMaster>$RSS_WEBMASTER</webMaster>\n".
                      "  <language>$RSS_LANG</language>\n".
                      "  <image>\n".
                      "    <url>$URL/images/logos/homesite_maker_small.jpg</url>\n".
                      "    <title>$TITLE</title>\n".
                      "    <link>$URL</link>\n".
                      "    <description>$TITLE Home</description>\n".
                      "    <width>90</width>\n".
                      "    <height>114</height>\n".
                      "  </image>\n";

           if (!$file_descriptor = fopen($rss_file, 'w'))
              {
              echo "Cannot open file ($rss_file)";
              exit;
              }
           if (fwrite($file_descriptor, $headers) === FALSE) 
              {
              echo "Cannot write to file ($rss_file)";
              exit;
              }

           fclose($file_descriptor);

           $news_query=mysql_query("
                                   SELECT *
                                   FROM info
                                   WHERE section='$section_name_str' AND status='2' AND headline NOT LIKE 'Headline_Tab___Section__'
                                   ORDER BY posted DESC LIMIT 0,$RSS_HISTORY
                                   ", $db);

           $file_descriptor = fopen($rss_file, 'a');
           while ($news_result=mysql_fetch_array ($news_query))
                 {
		 $intro=xmlentities($news_result['intro_text']);
		 $body=xmlentities($news_result['body_text']);
                 $description=$intro."&lt;br&gt;".$body;
                 $id_author=$news_result['id_author'];
                 $author_query=mysql_query("
                                           SELECT nick, email
                                           FROM users
                                           WHERE id_user=$id_author
                                           ", $db);
                 $author_result=mysql_fetch_array ($author_query);
                 $string_date=$news_result['edited'];
                 $timestamp = strtotime("$string_date");
                 $pub_date=date('D, d M Y H:i:s T', $timestamp);
                 $item = "  <item>\n".
                         "    <title>".$news_result['headline']."</title>\n".
                         "    <link>\n".
                         "    $URL/index.php?top_tab=1&amp;section_type=1&amp;task=read_more&amp;id_info=".$news_result['id_info'].
                         "    </link>\n".
                         "    <comments>\n".
                         "    $URL/index.php?top_tab=1&amp;section_type=1&amp;task=show_comments&amp;id_info=".$news_result['id_info']."\n".
                         "    </comments>\n".
                         "    <pubDate>$pub_date</pubDate>\n".
                         "    <author>".$author_result['email']." (".$author_result['nick'].")</author>\n".
                         "    <guid>".$news_result['id_info']."</guid>\n".
                         "    <description>$description</description>\n".
                         "  </item>\n";
                 fwrite($file_descriptor, $item);
                 }
           fclose($file_descriptor);
           $footer = "</channel>\n".
                     "</rss>\n";
           $file_descriptor = fopen($rss_file, 'a');
           fwrite ($file_descriptor, $footer);
           fclose($file_descriptor);
           echo "<span class=\"text1\"><center><br><br>$TEXT002</center><br><br>";
           } else if ( file_exists ($rss_file)) unlink ($rss_file);
        }
    }

?>
