<?php

/*
Home Site Maker, the websites factory.
Copyright (C) 2004, 2005 Marcos Martinez Jimenez

This file is part of Home Site Maker.

    Home Site Maker is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Home Site Maker is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Home Site Maker; see the file COPYING. If not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


Marcos Martinez Jimenez
marcos@assl-site.net
http://homesitemaker.no-ip.org
Francesc Llunell n 1 4 5, Esplugues de Llobregat, 08950 Barcelona, Spain
*/


/*
Configuration file for HomeSite M.A.K.E.R

 How to edit the config_site.php file ?

 - The [REQUIRED] variables should be modified with your own site values
 - You must to customize the variables identified with the [EDIT] tag
 - The [OPT] ones are optional, and you can leave they untouched
 - The [TRANS] tag is used when the only thing you need to do is translate the value to you own langauaje
 - Don't edit the variables with the [STOP] comment if you don't know exactly what you are doing
*/


$VERSION="homesitemaker-v0.4.1";                         // [STOP] Only for upgrading purporses
$TITLE="HomeSite M.A.K.E.R";                             // [EDIT] The title of your website
$DESCRIPTION="The Homesite M.A.K.E.R project home page"; // [EDIT] A brief description of your website
$URL="http://homesitemaker-devel.no-ip.org";             // [REQUIRED] The URL used to serve your site

$SKIN="aqua";         // [OPT] Available skins are rainbow, aqua, simple, black-simple and black-grey
$LANGUAGE="english";  // [EDIT] Available languages are english, spanish and catalan (since 0.4.1 version).
$RSS_LANG="es";       // [REQUIRED] Use only ISO 639 codes es, en, de, ca, etc.
$RSS_HISTORY="10";    // [OPT] Set the maximun number of news per XML/RSS feed file.
$RSS_EDITOR="editor@something.com";          // [REQUIRED] Email address of person responsible for editorial content.
$RSS_WEBMASTER="webmaster@something.com";    // [REQUIRED] Email address of person responsible for technical issues relating to channel

// MySQL database configuration values
$DB_USER="homesite_user";      // [REQUIRED] The MySQL database user
$DB_PASSWD="homesite_passwd";  // [REQUIRED] The MySQL user password
$DB_NAME="homesite_db";        // [REQUIRED] The MySQL database name

$DEFAULT_TAB="1";     // [OPT] Set the tab that shuold be on top when no one is selected (default option)
$DEFAULT_SECTION="1"; // [OPT] Set the tab that shuold be on top when no one is selected (default option)

/* Set the title you wants for the main sections (tabs) and subsections (sections)
   There are 4 section types for the SECTION_TYPE variable.
      info  -> It Allows you to edit the content of one static page in a easy way, allowing you to attach images
      news  -> It Allows you to send news with attached images and post comments
      album -> A management system for your image albums with full access control system.
      diary -> Not already finished
      NO    -> Hide, no section is showed */

$TAB_1="Home";           // [EDIT] Title for the main section 1 (tab 1)
$TAB_2="Albums";         // [EDIT] Title for the main section 2 (tab 2)
$TAB_3="About";          // [EDIT] Title for the main section 3 (tab 3)
$TAB_4="Help";           // [EDIT] Title for the main section 4 (tab 4)
$TAB_5="Control Panel";  // [TRANS] Title for the control panel (tab 5)

$TAB_11="News";           $SECTION_TYPE_11="news";    // [EDIT][EDIT] Title and type of the section 1 of the tab 1
$TAB_12="Contact";        $SECTION_TYPE_12="info";    // [EDIT][EDIT] Title and type of the section 2 of the tab 1
$TAB_13="Downloads";      $SECTION_TYPE_13="info";    // [EDIT][EDIT] Title and type of the section 3 of the tab 1
$TAB_14="NO";             $SECTION_TYPE_14="NO";      // [EDIT][EDIT] Title and type of the section 4 of the tab 1

$TAB_21="Sports";         $SECTION_TYPE_21="album";   // [EDIT][EDIT] Title and type of the section 1 of the tab 2
$TAB_22="Art Gallery";    $SECTION_TYPE_22="album";   // [EDIT][EDIT] Title and type of the section 2 of the tab2
$TAB_23="NO";             $SECTION_TYPE_23="NO";      // [EDIT][EDIT] Title and type of the section 3 of the tab 2
$TAB_24="NO";             $SECTION_TYPE_24="NO";      // [EDIT][EDIT] Title and type of the section 4 of the tab 2

$TAB_31="Events";         $SECTION_TYPE_31="diary";   // [EDIT][EDIT] Title and type of the section 1 of the tab 3
$TAB_32="Links";          $SECTION_TYPE_32="info";    // [EDIT][EDIT] Title and type of the section 2 of the tab 3
$TAB_33="Site Map";       $SECTION_TYPE_33="info";    // [EDIT][EDIT] Title and type of the section 3 of the tab 3
$TAB_34="NO";             $SECTION_TYPE_34="NO";      // [EDIT][EDIT] Title and type of the section 4 of the tab 3

$TAB_41="FAQs";           $SECTION_TYPE_41="info";    // [EDIT][EDIT] Title and type of the section 1 of the tab 4
$TAB_42="Handbook";       $SECTION_TYPE_42="info";    // [EDIT][EDIT] Title and type of the section 2 of the tab 4
$TAB_43="NO";             $SECTION_TYPE_43="NO";      // [EDIT][EDIT] Title and type of the section 3 of the tab 4
$TAB_44="NO";             $SECTION_TYPE_44="NO";    // [EDIT][EDIT] Title and type of the section 4 of the tab 4

$TAB_51="Users";          $SECTION_TYPE_51="users";   // [TRANS][STOP] Don't touch this if you don't know what you are doing
$TAB_52="Config";         $SECTION_TYPE_52="config";  // [TRANS][STOP] Don't touch this if you don't know what you are doing
$TAB_53="Look & Feel";    $SECTION_TYPE_53="site";    // [TRANS][STOP] Don't touch this if you don't know what you are doing
$TAB_54="Help";           $SECTION_TYPE_54="help";    // [TRANS][STOP] Don't touch this if you don't know what you are doing

$P_ITEMS="YES";           // [OPT] If you wants to show pending items to be published in the left pannel say yes here.
$STATS="YES";             // [OPT] If you wants to show some stats in the left pannel say yes here.


// The following tags allows you to put HTML code in every of the five empty boxes of the webpage.
// As you can see in the example, you can use the <img> tag in order to put an image inside it.
// All of they are optional [OPT]
$LOGO1="<div class=\"text6\"><center>HomeSite<br>M.A.K.E.R</center></div>";
$LOGO2="";
$LOGO3="";
$LOGO4="";
$LOGO5="<center><img src=\"images/logos/homesite_maker-blue.jpg\"></center>";

$SIZE_BOX1="90";           //[OPT] To modify the height of the box 1
$SIZE_BOX2="90";           //[OPT] To modify the height of the box 2
$SIZE_BOX3="90";           //[OPT] To modify the height of the box 3
$SIZE_BOX4="90";           //[OPT] To modify the height of the box 4
$SIZE_BOX5="180";          //[OPT] To modify the height of the box 5
$SIZE_LEFT_BOX="620";      //[OPT] To modify the height of the left box
$SIZE_LOGIN_BOX="230";     //[OPT] To modify the height of the login box
$SIZE_FOOTER="55";         //[OPT] To modify the height of the footer box

$FOOTER_TEXT="This site is powered by <a href=\"http://homesitemaker.no-ip.org\" target=\"new\">HomeSite M.A.K.E.R</a>".
             " code. This code is distibuted under <a href=\"http://www.gnu.org/licenses/gpl.html\" target=\"new\">GNU/GPL</a>".
             " license and are made by melmak from <a href=\"http://www.assl-site.net\" target=\"new\">www.assl-site.net</a>".
             "<br>All trademarks and copyrights on this page are owned by their respective owners.".
             "<center>".
             "<a href=\"http://www.mysql.com\" target=\"new\">".
             "<img border=0 title=\"Powered by MySQL Database Server\" vspace=1 src=\"images/logos/mysql_powered.png\">".
             "</img></a>&nbsp;&nbsp;&nbsp;&nbsp;".
             "<a href=\"http://www.php.net\" target=\"new\">".
             "<img border=0 title=\"Powered by PHP: Hypertext Preprocessor\" vspace=3 src=\"images/logos/php_powered.png\"></img></a>".
             "</center>";

?>
