#
# Copyright (C) 2010 Alexander Taler <dissent@0--0.org>
#

# This file is part of hsh.

# hsh is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# hsh is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with hsh.  If not, see <http://www.gnu.org/licenses/>.

######################################################################

# Test the content module

import unittest
import hsh.content.text

class ContentTester(unittest.TestCase):

    def setUp(self):
        self.tc = hsh.content.text.MutableText()

    def validate_mutabletext(self):
        ret = True
        for ln in self.tc:
            sl = ln.__len__()
            rl = reduce(lambda x,y: x+y, map(lambda x: x._length, ln.regions),0)
            if sl != rl:
                print "Region mismatch issue: %s %s" % (sl, rl)
                ret = False
        return ret

    def test_MutableText(self):
        # Ensure that MutableText enforces newline and type restrictions.
        self.tc.insert(0, "b")
        self.tc.insert(0, "a\n")
        self.assertEqual(2, len(self.tc))
        self.assertRaises(Exception, lambda : self.tc.insert(0, "a"))
        self.assertRaises(Exception, lambda : self.tc.append("a\n"))
        self.tc[1].append("\n")
        self.assertRaises(TypeError, lambda : self.tc.append(33))

    def test_TextLine(self):
        # Ensure that TextLine enforces newline and type restrictions.
        self.tc.insert(0, "c\n")
        self.assertEqual(hsh.content.text.TextLine, type(self.tc[0]))
        self.tc[0].insert(0, "h")
        self.assertEqual("hc\n", str(self.tc[0]))
        self.assertRaises(Exception, lambda : self.tc[0].insert(0, "\n"))
        self.assertRaises(Exception, lambda : self.tc[0].append_region("xxx"))
        self.assertTrue(self.validate_mutabletext())

        self.tc.append("uuu")
        self.assertEqual(2, len(self.tc))
        self.assertEqual(1, len(self.tc[1].regions))
        self.tc[1].append_region("xxx")
        self.assertEqual(2, len(self.tc[1].regions))
        self.tc[1].extend("foo")
        self.assertEqual("uuuxxxfoo", str(self.tc[1]))
        self.assertTrue(self.validate_mutabletext())

        # Test appending regions
        self.tc[-1].append("\n")
        self.tc.append_region("xxxxx\n")
        self.assertEqual("xxxxx\n", str(self.tc[-1]))
        self.assertEqual("xxxxx\n", str(self.tc[-1].regions[0]))
        self.assertEqual(1, len(self.tc[-1].regions))
        self.assertEqual(6, len(self.tc[-1].regions[0]))
        self.assertTrue(self.validate_mutabletext())

        # Test replacing parts of line
        self.tc.append_region("1")
        self.tc.append_region("2")
        self.tc.append_region("333")
        self.tc[-1][2:3] = "replace first 3"
        self.assertTrue(self.validate_mutabletext())
        self.tc[-1][1:2] = "replace 2"
        self.assertTrue(self.validate_mutabletext())

    def test_TextRegion(self):
        self.tc.insert(0, "aaa")
        self.tc[0].append_region("bb\n")
        self.assertEqual("aaa", str(self.tc[0].regions[0]))
        self.assertEqual("bb\n", str(self.tc[0].regions[1]))
        self.tc[0].regions[0].random_attr = 'attrval'
        reg0 = self.tc[0].regions[0]
        reg0[1:2] = "uuu"
        self.assertEqual("auuua", str(self.tc[0].regions[0]))
        def broken_set():
            reg0[51:2] = "jsjs"
        self.assertRaises(Exception, broken_set)

if __name__ == '__main__':
    unittest.main()
