#
# Copyright (C) 2010 Alexander Taler <dissent@0--0.org>
#

# This file is part of hsh.

# hsh is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# hsh is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with hsh.  If not, see <http://www.gnu.org/licenses/>.

######################################################################

# Wrappers around system information

import logging
import os
import pwd

import hsh

username = None

def get_username():
    global username
    if username is None:
        username = ""
        try:
            uid = os.geteuid()
            if uid == 0:
                # In case an exception is raised, assume 0 is root.
                username = "root"

            username = pwd.getpwuid(uid).pw_name
        except:
            try:
                username = os.environ["USERNAME"]
            except:
                pass
    return username

hostname = None

def get_hostname():
    global hostname
    if hostname is None:
        try:
            hostname = os.uname()[1]
        except:
            try:
                hostname = os.environ["HOSTNAME"]
            except:
                hostname = ""
    return hostname

cwd = os.getcwd()

def get_cwd():
    global cwd
    try:
        syscwd = os.getcwd()
        if syscwd != cwd:
            logging.warning("Warning: cwd changed without using hsh.system")
            logging.warning("  which affects behaviour when cwd disappears")
            cwd = syscwd
    except:
        # The cwd is inaccessible, so move towards root until something
        # reasonable is found.
        hsh.display_obj.show_alert("cwd is inaccessible, changing")
        while os.path.dirname(cwd) != cwd:
            try:
                cwd = os.path.dirname(cwd)
                os.chdir(cwd)
                break
            except:
                pass
    return cwd

def set_cwd(new_cwd):
    global cwd
    logging.debug("chaning to: %s" % new_cwd)
    os.chdir(new_cwd)
    cwd = os.getcwd()
