#
# Copyright (C) 2010 Alexander Taler <dissent@0--0.org>
#

# This file is part of hsh.

# hsh is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# hsh is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with hsh.  If not, see <http://www.gnu.org/licenses/>.

######################################################################

# The format of the user configuration file is to be determined.

import hsh.content.text

from hsh.exceptions import *
from view import View
from content_view import ContentView

class MessageView(ContentView):

    def __init__(self, display, name, message, can_focus=True):
        text = hsh.content.text.TextList(message.split('\n'))
        super(MessageView, self).__init__(display, text, name)
        self.can_focus = can_focus

    def set_message(self, message):
        self.text[:] = message.split('\n')
        self.set_dirty()

    def set_focus(self, *args, **kwargs):
        if not self.can_focus:
            return False
        return super(MessageView, self).set_focus(*args, **kwargs)
