#
# Copyright (C) 2010 Alexander Taler <dissent@0--0.org>
#

# This file is part of hsh.

# hsh is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# hsh is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with hsh.  If not, see <http://www.gnu.org/licenses/>.

######################################################################

import os
import os.path
import curses

# Configuration and data directory access for hsh.

version = '1.-2.4'

conf_dir = os.path.join(os.environ["HOME"], ".hsh")
jobs_dir = os.path.join(conf_dir, "jobs")

if not os.path.exists(conf_dir):
    os.mkdir(conf_dir)
elif not os.path.isdir(conf_dir):
    raise Exception("Expected a directory: " + conf_dir)

if not os.path.exists(jobs_dir):
    os.mkdir(jobs_dir)

# General Configuration

builtin_suppressor = '+'
tab_width = 8

# Display faces

# BLACK, RED, GREEN, YELLOW, BLUE, MAGENTA, CYAN, WHITE

faces = {
    "default":          (curses.COLOR_WHITE,   curses.COLOR_BLACK),
    "text":             (curses.COLOR_WHITE,   curses.COLOR_BLACK),
    "wrapmark":         (curses.COLOR_CYAN,    curses.COLOR_BLACK),
    "stdout":           (curses.COLOR_WHITE,   curses.COLOR_BLACK),
    "stderr":           (curses.COLOR_RED,     curses.COLOR_BLACK),
    "stdin":            (curses.COLOR_YELLOW,  curses.COLOR_BLACK),
    "editbuff":         (curses.COLOR_WHITE,   curses.COLOR_MAGENTA),
    "header":           (curses.COLOR_YELLOW,  curses.COLOR_BLACK),
    "headerwrapmark":   (curses.COLOR_CYAN,    curses.COLOR_BLACK),
    "prefix":           (curses.COLOR_YELLOW,  curses.COLOR_BLACK),
    "listjobheader":    (curses.COLOR_BLUE,    curses.COLOR_BLACK),
    "highlight":        (curses.COLOR_WHITE,   curses.COLOR_BLUE),
    "search":           (curses.COLOR_WHITE,   curses.COLOR_MAGENTA),

    "JobView.header":           (curses.COLOR_WHITE,   curses.COLOR_BLUE),
    "JobView.headerwrapmark":   (curses.COLOR_CYAN,    curses.COLOR_BLUE),

    "Alert.text":               (curses.COLOR_WHITE,   curses.COLOR_RED),

    "SearchView.text":          (curses.COLOR_MAGENTA, curses.COLOR_BLACK),
    "SearchView.prefix":        (curses.COLOR_WHITE,   curses.COLOR_MAGENTA),

    "CommandHistory.highlight":     (curses.COLOR_YELLOW,  curses.COLOR_BLACK),
    "CommandHistory.listjobheader": (curses.COLOR_WHITE,   curses.COLOR_BLACK),
}

# Output formats

header_input = ("%(username)s@%(hostname)s:%(cwd)s\n"
                "%(expanded_cmd)s\n"
                "%(completions)s")

header_job = ("%(username)s@%(hostname)s:%(cwd)s> %(cmd_line)s\n"
              "%(expanded_cmd)s\n"
              "job %(jobid)s, pid %(pid)s %(state)s - "
              "showing from line %(display_line)s/%(total_lines)s - "
              "input mode: %(input_mode)s - %(output_tail)s")

# Job lists

listviews = [

    { 'name' : "SessionList",
      'job_filter' : 
            lambda x: ((x.get_state() != "NotRun")
                       and x.is_new),
      'header' : "",
      'show_job_output' : True,
      'sync_main_job' : True,
      'job_header_fmt' : "(%(jobid)s) %(username)s@%(hostname)s:%(cwd)s\n"
                  "%(state)s> %(expanded_cmd)s" },

    { 'name' : "RunningJobs",
      'job_filter' : lambda x: x.get_state() in ["Running", "Initializing"]
                               and x.is_new,
      'header' : "    Running Jobs   \n",
      'job_header_fmt' : "%(username)s@%(hostname)s:%(cwd)s> %(expanded_cmd)s\n"
                   "(%(jobid)s) %(state)s - %(total_lines)s lines of output\n"},

    { 'name' : "CommandHistory",
      'job_filter' : lambda x: True,
      'job_header_fmt' : "%(jobid)s %(cmd_line)s" },

    { 'name' : "JobHistory",
      'job_filter' : 
            lambda x: ((x.get_state() != "NotRun")),
      'header' : "    Full Job History   \n",
      'job_header_fmt' : "%(username)s@%(hostname)s:%(cwd)s> %(expanded_cmd)s\n"
                  "(%(jobid)s) %(state)s - %(total_lines)s lines of output\n" },

    ]

# Typically useful default aliases

default_aliases = {
    'gpg' : 'gpg #exclusive',
    'sudo' : 'sudo #exclusive',
    'ssh' : 'ssh #exclusive',
    'aptitude' : 'aptitude #exclusive',
    'info' : 'info #exclusive',

    'python' : 'python #pty',
    'sh' : 'sh #pty',
    'top' : 'top #pty',

    'quit' : 'exit',
    'logout' : 'exit',
    'bye' : 'exit',

    'history' : 'hsh_view CommandHistory',
    'jobs'    : 'hsh_view RunningJobs',
}
