#
# Copyright (C) 2010 Alexander Taler <dissent@0--0.org>
#

# This file is part of hsh.

# hsh is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# hsh is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with hsh.  If not, see <http://www.gnu.org/licenses/>.

######################################################################

import curses
import curses.ascii

keys_default = {
    (curses.KEY_LEFT, False):          "move_left",
    (curses.KEY_RIGHT, False):         "move_right",
    (curses.KEY_DOWN, False):          "move_down",
    (curses.KEY_UP, False):            "move_up",
    (curses.KEY_NPAGE, False):         "page_down",
    (curses.KEY_PPAGE, False):         "page_up",
    (curses.KEY_BACKSPACE, False):     "delete_left",
    (curses.KEY_DC, False):            "delete_right",
    (curses.ascii.SOH, False):         "move_start",   # ^A
    (curses.ascii.STX, False):         "move_left",    # ^B
    (curses.ascii.EOT, False):         "delete_right", # ^D
    (curses.ascii.ENQ, False):         "move_end",     # ^E
    (curses.ascii.ACK, False):         "move_right",   # ^F
    (curses.ascii.BS, False):          "change_view",  # ^H
    (curses.ascii.VT, False):          "delete_line",  # ^K
    # (curses.ascii.SI, False):          "next_window",  # ^O
    (curses.ascii.DC1, False):         "quit",         # ^Q
    (curses.ascii.EM, False):          "paste",        # ^Y
    (ord('d'), True):                  "delete_job",
    (ord('n'), True):                  "next_job",
    (ord('o'), True):                  "next_window",
    (ord('p'), True):                  "prev_job",
    (ord('r'), True):                  "restart_job",
    (9, True):                         "next_window",  # Alt-Tab
}

func_keys = [curses.KEY_F1, curses.KEY_F2, curses.KEY_F3, curses.KEY_F4,
             curses.KEY_F5, curses.KEY_F6, curses.KEY_F7, curses.KEY_F8,
             curses.KEY_F9, curses.KEY_F10, curses.KEY_F11, curses.KEY_F12]

preds_default = [
    (lambda cl,ki: not ki.meta and curses.ascii.isprint(ki.key), "insert"),
    (lambda cl,ki: not ki.meta and ki.key in func_keys , "change_view"),
]

keys_CursesInput = {
    (curses.KEY_DOWN, False):          "forward_history",
    (curses.KEY_UP, False):            "back_history",
    (curses.ascii.ETX, False):         "cancel",           # ^C
    (curses.ascii.TAB, False):         "tab_complete",     # ^I
    (curses.ascii.NL, False):          "do_command",
    (curses.KEY_NPAGE, False):         "main_page_down",
    (curses.KEY_PPAGE, False):         "main_page_up",
    (ord('q'), True):                  "dump_parse_tree",
}

preds_CursesInput = {
}

keys_CursesJobDisplay = {
    (ord('i'), True):                  "cycle_input",
    (ord('c'), True):                  "close_input",
    (ord('t'), True):                  "toggle_tail",
    (curses.ascii.NL, False):          "input_line",
}

keys_SessionList = {
    (curses.ascii.NL, False):          "select_job",
    (curses.ascii.EOT, False):         "delete_job",  # ^D
    (curses.KEY_BACKSPACE, False):     "delete_job",
    (curses.KEY_DC, False):            "delete_job",
}

keys_CommandHistory = {
    (curses.ascii.NL, False):          "input_command",
}

keys_RunningJobs = {
    (curses.ascii.NL, False):          "select_job",
}
