#
# Copyright (C) 2010 Alexander Taler <dissent@0--0.org>
#

# This file is part of hsh.

# hsh is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# hsh is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with hsh.  If not, see <http://www.gnu.org/licenses/>.

######################################################################

# Public curses_display code includes each class as its own name, rather than
# in a submodule.

import curses
import curses.ascii

import hsh.debug

from display import CursesDisplay

# Treat display as a singleton.
hsh.display_obj = None

def run():
    try:
        stdscr = curses.initscr()
        curses.noecho()
        curses.raw()
        stdscr.keypad(1)

        hsh.display_obj = CursesDisplay(stdscr)
        hsh.display_obj.run()

    finally:
        stdscr.keypad(0)
        curses.noraw()
        curses.echo()
        curses.endwin()
