#
# Copyright (C) 2010 Alexander Taler <dissent@0--0.org>
#

# This file is part of hsh.

# hsh is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# hsh is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with hsh.  If not, see <http://www.gnu.org/licenses/>.

######################################################################

import os
import os.path
import curses

# Syntax stuff

builtin_commencer = '+'

# Configuration and data directory access for hsh.

version = '1.-2.1'

conf_dir = os.path.join(os.environ["HOME"], ".hsh")
jobs_dir = os.path.join(conf_dir, "jobs")

if not os.path.exists(conf_dir):
    os.mkdir(conf_dir)
elif not os.path.isdir(conf_dir):
    raise Exception("Expected a directory: " + conf_dir)

if not os.path.exists(jobs_dir):
    os.mkdir(jobs_dir)

# Display faces

# BLACK, RED, GREEN, YELLOW, BLUE, MAGENTA, CYAN, WHITE

faces = {
    "default":      (curses.COLOR_WHITE,   curses.COLOR_BLACK),
    "alert":        (curses.COLOR_WHITE,   curses.COLOR_RED),
    "input.header": (curses.COLOR_YELLOW, curses.COLOR_BLACK),
    "input.body":   (curses.COLOR_WHITE, curses.COLOR_BLACK),
    "job.header":   (curses.COLOR_WHITE, curses.COLOR_BLUE),
    "job.stdout":   (curses.COLOR_WHITE,   curses.COLOR_BLACK),
    "job.stderr":   (curses.COLOR_RED,     curses.COLOR_BLACK),
    "job.stdin":    (curses.COLOR_YELLOW,  curses.COLOR_BLACK),
    "job.in_buff":  (curses.COLOR_BLACK,   curses.COLOR_YELLOW),

    "list.header":     (curses.COLOR_YELLOW,  curses.COLOR_BLACK),
    "list.highlight":  (curses.COLOR_WHITE,   curses.COLOR_BLUE),
    "list.highlight2": (curses.COLOR_YELLOW,  curses.COLOR_BLACK),
}

# Output formats

header_input = ("%(username)s@%(hostname)s:%(cwd)s\n"
                "%(expanded_cmd)s\n"
                "%(completions)s")

header_job = ("%(username)s@%(hostname)s:%(cwd)s> %(cmd_line)s\n"
              "%(expanded_cmd)s\n"
              "job %(jobid)s, pid %(pid)s %(state)s - "
              "showing from line %(display_line)s/%(total_lines)s - "
              "input mode: %(input_mode)s - %(output_tail)s")

# Job lists

listviews = [

    { 'name' : "SessionList",
      'keybind' : curses.KEY_F3,
      'job_filter' : 
            lambda x: ((x.get_state() != "NotRun")
                       and x.show_output()
                       and x.is_new),
      'header' : "    Session Jobs   \n",
      'display_format' : "%(username)s@%(hostname)s:%(cwd)s> %(expanded_cmd)s\n"
                  "(%(jobid)s) %(state)s - %(total_lines)s lines of output\n" },

    { 'name' : "RunningJobs",
      'keybind' : curses.KEY_F4,
      'job_filter' : lambda x: x.get_state() == "Running" and x.is_new,
      'header' : "    Running Jobs   \n",
      'display_format' : "%(username)s@%(hostname)s:%(cwd)s> %(expanded_cmd)s\n"
                   "(%(jobid)s) %(state)s - %(total_lines)s lines of output\n"},

    { 'name' : "CommandHistory",
      'keybind' : curses.KEY_F5,
      'job_filter' : lambda x: True,
      'highlight_face' : "list.highlight2",
      'display_format' : "%(jobid)s %(cmd_line)s" },

    { 'name' : "JobHistory",
      'keybind' : curses.KEY_F6,
      'job_filter' : 
            lambda x: ((x.get_state() != "NotRun") and x.show_output()),
      'header' : "    Full Job History   \n",
      'display_format' : "%(username)s@%(hostname)s:%(cwd)s> %(expanded_cmd)s\n"
                  "(%(jobid)s) %(state)s - %(total_lines)s lines of output\n" },

    ]
