#
# Copyright (C) 2010 Alexander Taler <dissent@0--0.org>
#

# This file is part of hsh.

# hsh is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# hsh is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with hsh.  If not, see <http://www.gnu.org/licenses/>.

######################################################################

# hsh built in commands.

import logging
import os
import sys

import hsh
import hsh.config
import welcome
import jobs

class bi_cd(jobs.BuiltInJob):
    def do_start(self):
        if len(self.cmd) != 2:
            raise Exception("cd takes exactly one parameter")
        else:
            os.chdir(self.cmd[1])

jobs.register_builtin("cd", bi_cd)

class bi_debug_dump(jobs.BuiltInJob):
    def do_start(self):
        if len(self.cmd) > 1:
            targets = self.cmd[1:]
        else:
            targets = ["cd_input"]
        for arg in targets:
            targetn = "hsh.display_obj." + arg
            logging.info("DEBUG dump of: %s" % targetn)
            target = eval(targetn)
            logging.info("  Class: %s" % target.__class__.__name__)
            logging.info("  %s" % target)
            if hasattr(target, "__dict__"):
                logging.info("  [")
                for (key,val) in target.__dict__.items():
                    logging.info("  %s -> %s" % (key, val))
                logging.info("  ]")
            else:
                logging.info("  No __dict__")

jobs.register_builtin("debug_dump", bi_debug_dump)

class bi_reexec(jobs.BuiltInJob):
    """Restart the hsh process using an exec."""
    def do_start(self):
        jobs.manager.terminate()
        os.execv(sys.argv[0], sys.argv)

jobs.register_builtin("reexec", bi_reexec)

class bi_cause_internal_error(jobs.BuiltInJob):
    """Raise an exception."""
    def do_start(self):
        raise Exception("User requested internal Exception")

jobs.register_builtin("cause_internal_error", bi_cause_internal_error)

class bi_copying(jobs.BuiltInJob):
    """Display the license and copyright."""
    def do_start(self):
        self.show_output_var = True
        self.output = map(lambda x: x + '\n', welcome.license_text.split('\n'))

jobs.register_builtin("copying", bi_copying)

class bi_version(jobs.BuiltInJob):
    """Display the version."""
    def do_start(self):
        self.show_output_var = True
        self.output = [hsh.config.version + "\n"]

jobs.register_builtin("version", bi_version)
