#!/bin/sh
#
# Copyright (C) 2010 Alexander Taler <dissent@0--0.org>
#

# This file is part of hsh.

# hsh is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# hsh is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with hsh.  If not, see <http://www.gnu.org/licenses/>.

######################################################################

VERSION=1.-2.1
DEST=hsh-${VERSION}
SUBDIRS="doc src"

fail() {
    echo "Aborting: $1"
    exit 1
}

hg archive $DEST
cd $DEST

for sdir in doc src ; do
    cd $sdir
    make || fail "make failed in $sdir"
    cd -
done

# Update the code with the correct version
sed -i "s/'Development Version'/'${VERSION}'/" src/hsh/config.py

# Generate the ChangeLog from the previous tag
vsuf=${VERSION##*.}
vpref=${VERSION%.*}
OLD_VERSION=${vpref}.$(($vsuf - 1))
hg log -v -r tip:hsh-${OLD_VERSION} > ChangeLog

cd ..
tar cfz ${DEST}.tar.gz ${DEST}

hg status || fail "hg status failed"
test -z "`hg status`" || fail 'This tree has local changes'

echo gpg --detach-sign --armor ${DEST}.tar.gz
echo chmod 644 ${DEST}.tar.gz\*
echo scp ${DEST}.tar.gz ${DEST}.tar.gz.asc dissent@dl.sv.nongnu.org:/releases/hsh/
echo hg tag ${DEST}
