/*
   Copyright (C)  2000    Daniel A. Atkinson  <DanAtk@aol.com>
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include"cxpre.h"		/* Automatically includes "xpre.h" */

extern int x_sgn (struct xpr x);	/* see constant.c */

struct cxpr
cxadd (struct cxpr z1, struct cxpr z2, int k)
{
  struct cxpr w;

  w.re = xadd (z1.re, z2.re, k);
  w.im = xadd (z1.im, z2.im, k);
  return w;
}

struct cxpr
cxsum (struct cxpr z1, struct cxpr z2)
{
  struct cxpr w;

  w.re = xadd (z1.re, z2.re, 0);
  w.im = xadd (z1.im, z2.im, 0);
  return w;
}

struct cxpr
cxsub (struct cxpr z1, struct cxpr z2)
{
  struct cxpr w;

  w.re = xadd (z1.re, z2.re, 1);
  w.im = xadd (z1.im, z2.im, 1);
  return w;
}

struct cxpr
cxmul (struct cxpr z1, struct cxpr z2)
{
  struct cxpr w;

  w.re = xadd (xmul (z1.re, z2.re), xmul (z1.im, z2.im), 1);
  w.im = xadd (xmul (z1.im, z2.re), xmul (z1.re, z2.im), 0);
  return w;
}

/* Multiplication by a real number */
struct cxpr
cxrmul (struct xpr c, struct cxpr z)
{
  struct cxpr w;

  w.re = xmul (c, z.re);
  w.im = xmul (c, z.im);
  return w;
}

/* Multiplication by +i */
struct cxpr
cxdrot (struct cxpr z)
{
  z.im.nmm[0] ^= xM_sgn;
  return (struct cxpr)
  {
  z.im, z.re};
}

/* Multiplication by -i */
struct cxpr
cxrrot (struct cxpr z)
{
  z.re.nmm[0] ^= xM_sgn;
  return (struct cxpr)
  {
  z.im, z.re};
}

struct cxpr
cxdiv (struct cxpr z1, struct cxpr z2)
{
  int tv = cxrec (z2, &z2);

  if (!xsigerr (!tv, XEDIV, "cxdiv()"))
    {
      struct cxpr w;

      w.re = xadd (xmul (z1.re, z2.re), xmul (z1.im, z2.im), 1);
      w.im = xadd (xmul (z1.im, z2.re), xmul (z1.re, z2.im), 0);
      return w;
    }
  else
    return cxZero;
}

struct cxpr
cxinv (struct cxpr z)
{
  int tv = cxrec (z, &z);

  if (!xsigerr (!tv, XEDOM, "cxinv()"))
    return z;
  else
    return cxZero;
}

struct cxpr
cxsqr (struct cxpr z)
{
  struct cxpr w;

  w.re = xadd (xmul (z.re, z.re), xmul (z.im, z.im), 1);
  w.im = xmul (xTwo, xmul (z.im, z.re));
  return w;
}

struct cxpr
cxsqrt (struct cxpr z)
{
  struct xpr mod, arg;
  struct cxpr w;

  if (x_sgn (z.re) == 0 && x_sgn (z.im) == 0)
    return cxZero;
  else
    {
      mod = xsqrt (cxabs (z));
      arg = xpr2 (cxarg (z), -1);
      w.re = xmul (mod, xcos (arg));
      w.im = xmul (mod, xsin (arg));
      return w;
    }
}
