/*
   Copyright (C)  2000    Daniel A. Atkinson  <DanAtk@aol.com>
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

/*
    Test:  xtoflt flttox

    Uses:  xtoflt flttox xtodbl dbltox xprxpr
*/
#include <stdio.h>
#include <math.h>
#include "xpre.h"

int decd = 30;
#define __N__ 16

int
main (void)
{
  struct xpr z, w;
  float f, f_;
  double d, d_;
  int i;

  printf ("     Test of Conversion's Functions\n");
  for (i = __N__; i >= 1; i--)
    {
      f = -(float) sqrt (i);
      d = -sqrt (i);
      w = flttox (f);
      z = dbltox (d);
      f_ = xtoflt (w);
      d_ = xtodbl (z);
      printf ("-sqrt(%3d) = %+10.15f  %+10.15f  ", i, f, f_);
      xprxpr (w, decd);
      printf ("\n             %+10.15f  %+10.15f  ", d, d_);
      xprxpr (z, decd);
      putchar ('\n');
    }
  for (i = 0; i <= __N__; i++)
    {
      f = (float) sqrt (i);
      d = sqrt (i);
      w = flttox (f);
      z = dbltox (d);
      f_ = xtoflt (w);
      d_ = xtodbl (z);
      printf (" sqrt(%3d) = %+10.15f  %+10.15f  ", i, f, f_);
      xprxpr (w, decd);
      printf ("\n             %+10.15f  %+10.15f  ", d, d_);
      xprxpr (z, decd);
      putchar ('\n');
    }
  return 0;
}

/*  Test output

     Test of Conversion's Functions
-sqrt( 16) = -4.000000000000000  -4.000000000000000  -4.000000000000000000000000000000e+0
             -4.000000000000000  -4.000000000000000  -4.000000000000000000000000000000e+0
-sqrt( 15) = -3.872983455657959  -3.872983455657959  -3.872983455657958984375000000000e+0
             -3.872983346207417  -3.872983346207417  -3.872983346207417021389574074419e+0
-sqrt( 14) = -3.741657495498657  -3.741657495498657  -3.741657495498657226562500000000e+0
             -3.741657386773941  -3.741657386773941  -3.741657386773941329494164165226e+0
-sqrt( 13) = -3.605551242828369  -3.605551242828369  -3.605551242828369140625000000000e+0
             -3.605551275463989  -3.605551275463989  -3.605551275463989124858699142351e+0
-sqrt( 12) = -3.464101552963257  -3.464101552963257  -3.464101552963256835937500000000e+0
             -3.464101615137754  -3.464101615137754  -3.464101615137754386353208246874e+0
-sqrt( 11) = -3.316624879837036  -3.316624879837036  -3.316624879837036132812500000000e+0
             -3.316624790355400  -3.316624790355400  -3.316624790355399809982372971717e+0
-sqrt( 10) = -3.162277698516846  -3.162277698516846  -3.162277698516845703125000000000e+0
             -3.162277660168380  -3.162277660168380  -3.162277660168379522787063251599e+0
-sqrt(  9) = -3.000000000000000  -3.000000000000000  -3.000000000000000000000000000000e+0
             -3.000000000000000  -3.000000000000000  -3.000000000000000000000000000000e+0
-sqrt(  8) = -2.828427076339722  -2.828427076339722  -2.828427076339721679687500000000e+0
             -2.828427124746190  -2.828427124746190  -2.828427124746190290949243717478e+0
-sqrt(  7) = -2.645751237869263  -2.645751237869263  -2.645751237869262695312500000000e+0
             -2.645751311064591  -2.645751311064591  -2.645751311064590716171096573817e+0
-sqrt(  6) = -2.449489831924438  -2.449489831924438  -2.449489831924438476562500000000e+0
             -2.449489742783178  -2.449489742783178  -2.449489742783177881335632264381e+0
-sqrt(  5) = -2.236068010330200  -2.236068010330200  -2.236068010330200195312500000000e+0
             -2.236067977499790  -2.236067977499790  -2.236067977499789805051477742381e+0
-sqrt(  4) = -2.000000000000000  -2.000000000000000  -2.000000000000000000000000000000e+0
             -2.000000000000000  -2.000000000000000  -2.000000000000000000000000000000e+0
-sqrt(  3) = -1.732050776481628  -1.732050776481628  -1.732050776481628417968750000000e+0
             -1.732050807568877  -1.732050807568877  -1.732050807568877193176604123437e+0
-sqrt(  2) = -1.414213538169861  -1.414213538169861  -1.414213538169860839843750000000e+0
             -1.414213562373095  -1.414213562373095  -1.414213562373095145474621858739e+0
-sqrt(  1) = -1.000000000000000  -1.000000000000000  -1.000000000000000000000000000000e+0
             -1.000000000000000  -1.000000000000000  -1.000000000000000000000000000000e+0
 sqrt(  0) = +0.000000000000000  +0.000000000000000  5.877471754111437539843682686111e-39
             +0.000000000000000  +0.000000000000000  1.112536929253600691545116358666e-308
 sqrt(  1) = +1.000000000000000  +1.000000000000000  1.000000000000000000000000000000e+0
             +1.000000000000000  +1.000000000000000  1.000000000000000000000000000000e+0
 sqrt(  2) = +1.414213538169861  +1.414213538169861  1.414213538169860839843750000000e+0
             +1.414213562373095  +1.414213562373095  1.414213562373095145474621858739e+0
 sqrt(  3) = +1.732050776481628  +1.732050776481628  1.732050776481628417968750000000e+0
             +1.732050807568877  +1.732050807568877  1.732050807568877193176604123437e+0
 sqrt(  4) = +2.000000000000000  +2.000000000000000  2.000000000000000000000000000000e+0
             +2.000000000000000  +2.000000000000000  2.000000000000000000000000000000e+0
 sqrt(  5) = +2.236068010330200  +2.236068010330200  2.236068010330200195312500000000e+0
             +2.236067977499790  +2.236067977499790  2.236067977499789805051477742381e+0
 sqrt(  6) = +2.449489831924438  +2.449489831924438  2.449489831924438476562500000000e+0
             +2.449489742783178  +2.449489742783178  2.449489742783177881335632264381e+0
 sqrt(  7) = +2.645751237869263  +2.645751237869263  2.645751237869262695312500000000e+0
             +2.645751311064591  +2.645751311064591  2.645751311064590716171096573817e+0
 sqrt(  8) = +2.828427076339722  +2.828427076339722  2.828427076339721679687500000000e+0
             +2.828427124746190  +2.828427124746190  2.828427124746190290949243717478e+0
 sqrt(  9) = +3.000000000000000  +3.000000000000000  3.000000000000000000000000000000e+0
             +3.000000000000000  +3.000000000000000  3.000000000000000000000000000000e+0
 sqrt( 10) = +3.162277698516846  +3.162277698516846  3.162277698516845703125000000000e+0
             +3.162277660168380  +3.162277660168380  3.162277660168379522787063251599e+0
 sqrt( 11) = +3.316624879837036  +3.316624879837036  3.316624879837036132812500000000e+0
             +3.316624790355400  +3.316624790355400  3.316624790355399809982372971717e+0
 sqrt( 12) = +3.464101552963257  +3.464101552963257  3.464101552963256835937500000000e+0
             +3.464101615137754  +3.464101615137754  3.464101615137754386353208246874e+0
 sqrt( 13) = +3.605551242828369  +3.605551242828369  3.605551242828369140625000000000e+0
             +3.605551275463989  +3.605551275463989  3.605551275463989124858699142351e+0
 sqrt( 14) = +3.741657495498657  +3.741657495498657  3.741657495498657226562500000000e+0
             +3.741657386773941  +3.741657386773941  3.741657386773941329494164165226e+0
 sqrt( 15) = +3.872983455657959  +3.872983455657959  3.872983455657958984375000000000e+0
             +3.872983346207417  +3.872983346207417  3.872983346207417021389574074419e+0
 sqrt( 16) = +4.000000000000000  +4.000000000000000  4.000000000000000000000000000000e+0
             +4.000000000000000  +4.000000000000000  4.000000000000000000000000000000e+0
*/
