/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

/*
    Test:  xfout  xout  xsout

    Uses:  xfout  xout  xsout  atox  

    Input file:  data/xout.dat
*/

#include <stdio.h>
#include <stdlib.h>
#include "xpre.h"

#define BUFF_SIZE 5120 /* 5 Kb */
int decd=30;

void getflags (const char* buffer, struct xoutflags* pofs)
{
  sscanf (buffer, "%hi %hi %hi %hi %c", 
	  &pofs->notat, &pofs->sf, &pofs->mfwd, &pofs->lim, &pofs->padding);
}

int main(int na,char **av)
{ 
  struct xpr x;
  int i;
  char buffer[BUFF_SIZE];
  struct xoutflags ofs;
  unsigned long n;
  FILE *fp;

  if(na!=2)
    { 
      printf("para: input_file\n"); 
      exit(-1);
    }
  fp=fopen(*++av,"r");
  printf("     Test of Special Printing Functions\n");
  while( fgets(buffer, BUFF_SIZE, fp) != NULL )
    {
      for (i=0; buffer[i] != '\0'; i++);
      if ( i>0 && buffer[i-1] == '\n' )
	buffer[i-1] = '\0';
      if (buffer[0] == '*')
	{
	  getflags (buffer + 1, &ofs);
	  printf ("* %hi %hi %hi %hi %c\n",
		  ofs.notat, ofs.sf, ofs.mfwd, ofs.lim, ofs.padding);
	}
      else
	{
	  printf ("buffer : %s\n", buffer);
	  x = atox (buffer);
	  printf ("\t\t <%2d>\n", xfout (stdout, ofs, x));
	  printf ("\t\t <%2d>\n", xout (ofs, x));
	  n = xsout (buffer, 20, ofs, x);
	  printf ("%s\t\t <%2lu>\n", buffer, n);
	}
    }
  fclose (fp);
  return 0;
}
/*  Test output

     Test of Special Printing Functions
* 0 0 -1 -1 _
buffer : 345.0067
345.0067		 < 0>
345.0067		 < 0>
345.0067		 < 8>
buffer : -12.9807
-12.98070		 < 0>
-12.98070		 < 0>
-12.98070		 < 9>
buffer : +1
1.000000		 < 0>
1.000000		 < 0>
1.000000		 < 8>
buffer : -1.026e14
-102600000000000		 < 0>
-102600000000000		 < 0>
-102600000000000		 <16>
buffer : +3.045e-16
0.0000000000000003045000		 < 0>
0.0000000000000003045000		 < 0>
0.00000000000000030		 <24>
buffer : +17.000000000000023
17.00000		 < 0>
17.00000		 < 0>
17.00000		 < 8>
buffer : -21.00000000000000000023
-21.00000		 < 0>
-21.00000		 < 0>
-21.00000		 < 9>
* 0 0 -5 0 _
buffer : 345.0067
300__		 < 0>
300__		 < 0>
300__		 < 5>
buffer : -12.9807
-10__		 < 0>
-10__		 < 0>
-10__		 < 5>
buffer : +1
1____		 < 0>
1____		 < 0>
1____		 < 5>
buffer : -1.026e14
-100000000000000		 < 0>
-100000000000000		 < 0>
-100000000000000		 <16>
buffer : +3.045e-16
0.0000000000000003		 < 0>
0.0000000000000003		 < 0>
0.0000000000000003		 <18>
buffer : +17.000000000000023
20___		 < 0>
20___		 < 0>
20___		 < 5>
buffer : -21.00000000000000000023
-20__		 < 0>
-20__		 < 0>
-20__		 < 5>
* 0 0 -14 6 _
buffer : 345.0067
345.0067______		 < 0>
345.0067______		 < 0>
345.0067______		 <14>
buffer : -12.9807
-12.98070_____		 < 0>
-12.98070_____		 < 0>
-12.98070_____		 <14>
buffer : +1
1.000000______		 < 0>
1.000000______		 < 0>
1.000000______		 <14>
buffer : -1.026e14
-102600000000000		 < 0>
-102600000000000		 < 0>
-102600000000000		 <16>
buffer : +3.045e-16
0.0000000000000003045000		 < 0>
0.0000000000000003045000		 < 0>
0.00000000000000030		 <24>
buffer : +17.000000000000023
17.00000______		 < 0>
17.00000______		 < 0>
17.00000______		 <14>
buffer : -21.00000000000000000023
-21.00000_____		 < 0>
-21.00000_____		 < 0>
-21.00000_____		 <14>
* 0 0 -1 13 _
buffer : 345.0067
345.00670000000		 < 0>
345.00670000000		 < 0>
345.00670000000		 <15>
buffer : -12.9807
-12.980700000000		 < 0>
-12.980700000000		 < 0>
-12.980700000000		 <16>
buffer : +1
1.0000000000000		 < 0>
1.0000000000000		 < 0>
1.0000000000000		 <15>
buffer : -1.026e14
-102600000000000		 < 0>
-102600000000000		 < 0>
-102600000000000		 <16>
buffer : +3.045e-16
0.00000000000000030450000000000		 < 0>
0.00000000000000030450000000000		 < 0>
0.00000000000000030		 <31>
buffer : +17.000000000000023
17.000000000000		 < 0>
17.000000000000		 < 0>
17.000000000000		 <15>
buffer : -21.00000000000000000023
-21.000000000000		 < 0>
-21.000000000000		 < 0>
-21.000000000000		 <16>
* 0 0 -40 22 _
buffer : 345.0067
345.00670000000000000000________________		 < 0>
345.00670000000000000000________________		 < 0>
345.006700000000000		 <40>
buffer : -12.9807
-12.980700000000000000000_______________		 < 0>
-12.980700000000000000000_______________		 < 0>
-12.980700000000000		 <40>
buffer : +1
1.0000000000000000000000________________		 < 0>
1.0000000000000000000000________________		 < 0>
1.00000000000000000		 <40>
buffer : -1.026e14
-102600000000000.00000000_______________		 < 0>
-102600000000000.00000000_______________		 < 0>
-102600000000000.00		 <40>
buffer : +3.045e-16
0.00000000000000030450000000000000000000		 < 0>
0.00000000000000030450000000000000000000		 < 0>
0.00000000000000030		 <40>
buffer : +17.000000000000023
17.000000000000023000000________________		 < 0>
17.000000000000023000000________________		 < 0>
17.0000000000000230		 <40>
buffer : -21.00000000000000000023
-21.000000000000000000230_______________		 < 0>
-21.000000000000000000230_______________		 < 0>
-21.000000000000000		 <40>
* 0 0 0 4 _
buffer : 345.0067
345.01		 < 0>
345.01		 < 0>
345.01		 < 6>
buffer : -12.9807
-12.981		 < 0>
-12.981		 < 0>
-12.981		 < 7>
buffer : +1
1.0000		 < 0>
1.0000		 < 0>
1.0000		 < 6>
buffer : -1.026e14
-102600000000000		 < 0>
-102600000000000		 < 0>
-102600000000000		 <16>
buffer : +3.045e-16
0.00000000000000030450		 < 0>
0.00000000000000030450		 < 0>
0.00000000000000030		 <22>
buffer : +17.000000000000023
17.000		 < 0>
17.000		 < 0>
17.000		 < 6>
buffer : -21.00000000000000000023
-21.000		 < 0>
-21.000		 < 0>
-21.000		 < 7>
* 0 0 10 4 _
buffer : 345.0067
____345.01		 < 0>
____345.01		 < 0>
____345.01		 <10>
buffer : -12.9807
___-12.981		 < 0>
___-12.981		 < 0>
___-12.981		 <10>
buffer : +1
____1.0000		 < 0>
____1.0000		 < 0>
____1.0000		 <10>
buffer : -1.026e14
-102600000000000		 < 0>
-102600000000000		 < 0>
-102600000000000		 <16>
buffer : +3.045e-16
0.00000000000000030450		 < 0>
0.00000000000000030450		 < 0>
0.00000000000000030		 <22>
buffer : +17.000000000000023
____17.000		 < 0>
____17.000		 < 0>
____17.000		 <10>
buffer : -21.00000000000000000023
___-21.000		 < 0>
___-21.000		 < 0>
___-21.000		 <10>
* 0 0 20 6 #
buffer : 345.0067
############345.0067		 < 0>
############345.0067		 < 0>
############345.006		 <20>
buffer : -12.9807
###########-12.98070		 < 0>
###########-12.98070		 < 0>
###########-12.9807		 <20>
buffer : +1
############1.000000		 < 0>
############1.000000		 < 0>
############1.00000		 <20>
buffer : -1.026e14
####-102600000000000		 < 0>
####-102600000000000		 < 0>
####-10260000000000		 <20>
buffer : +3.045e-16
0.0000000000000003045000		 < 0>
0.0000000000000003045000		 < 0>
0.00000000000000030		 <24>
buffer : +17.0000000000023
############17.00000		 < 0>
############17.00000		 < 0>
############17.0000		 <20>
buffer : -21.00000000000000000023
###########-21.00000		 < 0>
###########-21.00000		 < 0>
###########-21.0000		 <20>
* 0 0 40 6 $
buffer : 345.0067
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$345.0067		 < 0>
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$345.0067		 < 0>
$$$$$$$$$$$$$$$$$$$		 <40>
buffer : -12.9807
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$-12.98070		 < 0>
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$-12.98070		 < 0>
$$$$$$$$$$$$$$$$$$$		 <40>
buffer : +1
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$1.000000		 < 0>
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$1.000000		 < 0>
$$$$$$$$$$$$$$$$$$$		 <40>
buffer : -1.026e14
$$$$$$$$$$$$$$$$$$$$$$$$-102600000000000		 < 0>
$$$$$$$$$$$$$$$$$$$$$$$$-102600000000000		 < 0>
$$$$$$$$$$$$$$$$$$$		 <40>
buffer : +3.045e-16
$$$$$$$$$$$$$$$$0.0000000000000003045000		 < 0>
$$$$$$$$$$$$$$$$0.0000000000000003045000		 < 0>
$$$$$$$$$$$$$$$$0.0		 <40>
buffer : +17.0000000000023
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$17.00000		 < 0>
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$17.00000		 < 0>
$$$$$$$$$$$$$$$$$$$		 <40>
buffer : -21.00000000000000000023
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$-21.00000		 < 0>
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$-21.00000		 < 0>
$$$$$$$$$$$$$$$$$$$		 <40>
* 0 1 20 3 '
buffer : 345.0067
''''''''''''''+345.0		 < 0>
''''''''''''''+345.0		 < 0>
''''''''''''''+345.		 <20>
buffer : -12.9807
''''''''''''''-12.98		 < 0>
''''''''''''''-12.98		 < 0>
''''''''''''''-12.9		 <20>
buffer : +1
''''''''''''''+1.000		 < 0>
''''''''''''''+1.000		 < 0>
''''''''''''''+1.00		 <20>
buffer : -1.026e14
''''-102600000000000		 < 0>
''''-102600000000000		 < 0>
''''-10260000000000		 <20>
buffer : +3.045e-16
+0.0000000000000003045		 < 0>
+0.0000000000000003045		 < 0>
+0.0000000000000003		 <22>
buffer : +17.0000000000023
''''''''''''''+17.00		 < 0>
''''''''''''''+17.00		 < 0>
''''''''''''''+17.0		 <20>
buffer : -21.00000000000000000023
''''''''''''''-21.00		 < 0>
''''''''''''''-21.00		 < 0>
''''''''''''''-21.0		 <20>
* 1 0 20 3 
buffer : 345.0067
            3.450e+2		 < 0>
            3.450e+2		 < 0>
            3.450e+		 <20>
buffer : -12.9807
           -1.298e+1		 < 0>
           -1.298e+1		 < 0>
           -1.298e+		 <20>
buffer : +1
            1.000e+0		 < 0>
            1.000e+0		 < 0>
            1.000e+		 <20>
buffer : -1.026e14
          -1.026e+14		 < 0>
          -1.026e+14		 < 0>
          -1.026e+1		 <20>
buffer : +3.045e-16
           3.045e-16		 < 0>
           3.045e-16		 < 0>
           3.045e-1		 <20>
buffer : +17.0000000000023
            1.700e+1		 < 0>
            1.700e+1		 < 0>
            1.700e+		 <20>
buffer : -21.00000000000000000023
           -2.100e+1		 < 0>
           -2.100e+1		 < 0>
           -2.100e+		 <20>
* 1 1 15 2 >
buffer : 345.0067
>>>>>>>+3.45e+2		 < 0>
>>>>>>>+3.45e+2		 < 0>
>>>>>>>+3.45e+2		 <15>
buffer : -12.9807
>>>>>>>-1.30e+1		 < 0>
>>>>>>>-1.30e+1		 < 0>
>>>>>>>-1.30e+1		 <15>
buffer : +1
>>>>>>>+1.00e+0		 < 0>
>>>>>>>+1.00e+0		 < 0>
>>>>>>>+1.00e+0		 <15>
buffer : -1.026e14
>>>>>>-1.03e+14		 < 0>
>>>>>>-1.03e+14		 < 0>
>>>>>>-1.03e+14		 <15>
buffer : +3.045e-16
>>>>>>+3.04e-16		 < 0>
>>>>>>+3.04e-16		 < 0>
>>>>>>+3.04e-16		 <15>
buffer : +17.0000000000023
>>>>>>>+1.70e+1		 < 0>
>>>>>>>+1.70e+1		 < 0>
>>>>>>>+1.70e+1		 <15>
buffer : -21.00000000000000000023
>>>>>>>-2.10e+1		 < 0>
>>>>>>>-2.10e+1		 < 0>
>>>>>>>-2.10e+1		 <15>
*/
