/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

/*
    Test:  xlog  xexp  xlog2  xexp2  xlog10  xexp10

    Uses:  atox  xprcmp  xadd  prxpr
*/
#include <stdio.h>
#include "xpre.h"

int decd=30;

int main(void)
{ 
  struct xpr z,h,f,w,u;
  
  printf("     Test of Log Functions\n");
  h=atox(".25"); z=h; w=atox("4.01");
  for(; xprcmp(&z,&w)<0 ;z=xadd(z,h,0))
    {
      /* compute extended precision natural logarithm */
      f=xlog(z);
      printf(" %8.4f  ",xtodbl(z)); prxpr(f,decd);

      /* check using exponential */
      u=xexp(f);
      printf("   exp(z)  "); prxpr(u,decd);

      /* compute extended precision base-2 logarithm */
      f=xlog2(z);
      printf(" %8.4f  ",xtodbl(z)); prxpr(f,decd);

      /* check using exponential */
      u=xexp2(f);
      printf("   exp2(z) "); prxpr(u,decd);

      /* compute extended precision base-10 logarithm */
      f=xlog10(z);
      printf(" %8.4f  ",xtodbl(z)); prxpr(f,decd);

      /* check using exponential */
      u=xexp10(f);
      printf("  exp10(z) "); prxpr(u,decd);
      putchar ('\n');
    }
  return 0;
}
/*  Test output

     Test of Log Functions
   0.2500   -1.386294361119890618834464242916e+0
   exp(z)    2.500000000000000000000000000000e-1
   0.2500   -2.000000000000000000000000000000e+0
   exp2(z)   2.500000000000000000000000000000e-1
   0.2500   -6.020599913279623904274777894490e-1
  exp10(z)   2.500000000000000000000000000000e-1

   0.5000   -6.931471805599453094172321214582e-1
   exp(z)    5.000000000000000000000000000000e-1
   0.5000   -1.000000000000000000000000000000e+0
   exp2(z)   5.000000000000000000000000000000e-1
   0.5000   -3.010299956639811952137388947245e-1
  exp10(z)   5.000000000000000000000000000000e-1

   0.7500   -2.876820724517809274392190059938e-1
   exp(z)    7.500000000000000000000000000000e-1
   0.7500   -4.150374992788438185462610560522e-1
   exp2(z)   7.500000000000000000000000000000e-1
   0.7500   -1.249387366082999531324498861939e-1
  exp10(z)   7.500000000000000000000000000000e-1

   1.0000   -3.948156385993833498764754782299e-33
   exp(z)    1.000000000000000000000000000000e+0
   1.0000   -6.162975822039154729779129416272e-33
   exp2(z)   1.000000000000000000000000000000e+0
   1.0000   -1.714662532128207060047859437090e-33
  exp10(z)   1.000000000000000000000000000000e+0

   1.2500    2.231435513142097557662950903098e-1
   exp(z)    1.250000000000000000000000000000e+0
   1.2500    3.219280948873623478703194294894e-1
   exp2(z)   1.250000000000000000000000000000e+0
   1.2500    9.691001300805641435878331582652e-2
  exp10(z)   1.250000000000000000000000000000e+0

   1.5000    4.054651081081643819780131154643e-1
   exp(z)    1.500000000000000000000000000000e+0
   1.5000    5.849625007211561814537389439478e-1
   exp2(z)   1.500000000000000000000000000000e+0
   1.5000    1.760912590556812420812890085306e-1
  exp10(z)   1.500000000000000000000000000000e+0

   1.7500    5.596157879354226862708885005268e-1
   exp(z)    1.750000000000000000000000000000e+0
   1.7500    8.073549220576041074419693172318e-1
   exp2(z)   1.750000000000000000000000000000e+0
   1.7500    2.430380486862944402847384691436e-1
  exp10(z)   1.750000000000000000000000000000e+0

   2.0000    6.931471805599453094172321214582e-1
   exp(z)    2.000000000000000000000000000000e+0
   2.0000    1.000000000000000000000000000000e+0
   exp2(z)   2.000000000000000000000000000000e+0
   2.0000    3.010299956639811952137388947245e-1
  exp10(z)   2.000000000000000000000000000000e+0

   2.2500    8.109302162163287639560262309287e-1
   exp(z)    2.250000000000000000000000000000e+0
   2.2500    1.169925001442312362907477887896e+0
   exp2(z)   2.250000000000000000000000000000e+0
   2.2500    3.521825181113624841625780170612e-1
  exp10(z)   2.250000000000000000000000000000e+0

   2.5000    9.162907318741550651835272117680e-1
   exp(z)    2.500000000000000000000000000000e+0
   2.5000    1.321928094887362347870319429489e+0
   exp2(z)   2.500000000000000000000000000000e+0
   2.5000    3.979400086720376095725222105510e-1
  exp10(z)   2.500000000000000000000000000000e+0

   2.7500    1.011600911678479925227479335049e+0
   exp(z)    2.750000000000000000000000000000e+0
   2.7500    1.459431618637297256199363046726e+0
   exp2(z)   2.750000000000000000000000000000e+0
   2.7500    4.393326938302626503227221817940e-1
  exp10(z)   2.750000000000000000000000000000e+0

   3.0000    1.098612288668109691395245236923e+0
   exp(z)    3.000000000000000000000000000000e+0
   3.0000    1.584962500721156181453738943948e+0
   exp2(z)   3.000000000000000000000000000000e+0
   3.0000    4.771212547196624372950279032551e-1
  exp10(z)   3.000000000000000000000000000000e+0

   3.2500    1.178654996341646117219023198649e+0
   exp(z)    3.250000000000000000000000000000e+0
   3.2500    1.700439718141092160396812654257e+0
   exp2(z)   3.250000000000000000000000000000e+0
   3.2500    5.118833609788743787790273684933e-1
  exp10(z)   3.250000000000000000000000000000e+0

   3.5000    1.252762968495367995688120621985e+0
   exp(z)    3.500000000000000000000000000000e+0
   3.5000    1.807354922057604107441969317232e+0
   exp2(z)   3.500000000000000000000000000000e+0
   3.5000    5.440680443502756354984773638681e-1
  exp10(z)   3.500000000000000000000000000000e+0

   3.7500    1.321755839982319447161540327232e+0
   exp(z)    3.750000000000000000000000000000e+0
   3.7500    1.906890595608518529324058373437e+0
   exp2(z)   3.750000000000000000000000000000e+0
   3.7500    5.740312677277188516538112190816e-1
  exp10(z)   3.750000000000000000000000000000e+0

   4.0000    1.386294361119890618834464242916e+0
   exp(z)    4.000000000000000000000000000000e+0
   4.0000    2.000000000000000000000000000000e+0
   exp2(z)   4.000000000000000000000000000000e+0
   4.0000    6.020599913279623904274777894490e-1
  exp10(z)   4.000000000000000000000000000000e+0

*/
