/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

/*
    Test:  xfmod  xfrex  xpr2

    Uses:  atox  prxpr

    Input parameters:  x -> extended precision: first argument
                       y -> extended precision: second argument
*/
#include <stdio.h>
#include "xpre.h"

int decd=30;

int main (int na,char **av)
{ 
  struct xpr s, t, f, q; 
  int k;
  
  if(na!=3) { printf("para: x y\n"); exit(-1);}
  printf("     Test of FMOD functions\n");
  s=atox(*++av); t=atox(*++av);
  printf(" inputs:\n");
  printf(" s="); prxpr(s,decd);
  printf(" t="); prxpr(t,decd);

  /* extended precision modular divide */
  f=xfmod(s,t,&q);
  printf(" s mod t = "); prxpr(f,decd);
  printf("       q = "); prxpr(q,decd);
  printf("\n s="); prxpr(s,decd);

  /* extended precision exponent extraction */
  s=xfrex(s,&k);
  printf(" exp= %d\n",k);
  printf(" <s>="); prxpr(s,decd);

  /* extended precision power of two */
  s=xpr2(s,k);
  printf("   s="); prxpr(s,decd);
  return 0;
}
/*  Test output

     Test of FMOD functions
 inputs:
 s=  1.250000000000000000000000000000e+1
 t=  3.000000000000000000000000000000e+0
 s mod t =   5.000000000000000000000000000000e-1
       q =   4.000000000000000000000000000000e+0

 s=  1.250000000000000000000000000000e+1
 exp= 4
 <s>=  7.812500000000000000000000000000e-1
   s=  1.250000000000000000000000000000e+1
*/
