/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

/*
    Test:  neg  xex  xabs  xneg  xpr2

    Uses:  atox  prxpr

    Input parameter:  x -> extended precision: test number
*/
#include <stdio.h>
#include "xpre.h"

int decd=30;

int main(int na,char **av)
{ 
  struct xpr s,t; int k;
  
  if(na!=2)
    { printf("para: test_num\n"); exit(-1);}
  printf("     Test of Utility Operations\n");
  s=atox(*++av);
  printf("   input x= "); prxpr(s,decd);

  /* t= -s */
  t=xneg(s);
  printf(" t=xneg(x)= "); prxpr(t,decd);

  /* s -> -s */
  neg(&s);
  printf("   neg(x) = "); prxpr(s,decd);

  /* extract exponent */
  k=xex(&s); printf(" x-exp= k = %d\n",k);
  s=xpr2(s,-k);
  printf("      <s> = "); prxpr(s,decd);

  /* restore exponent */
  s=xpr2(s,k);
  printf("  <s>*2^k = "); prxpr(s,decd);

  /* s -> |s| */
  t=xabs(s);
  printf(" t=abs(s) = "); prxpr(t,decd);
  return 0;
}
/*  Test output

     Test of Utility Operations
   input x=  -1.240000000000000000000000000000e-3
 t=xneg(x)=   1.240000000000000000000000000000e-3
   neg(x) =  -1.240000000000000000000000000000e-3
 x-exp= k = -10
      <s> =  -1.269760000000000000000000000000e+0
  <s>*2^k =  -1.240000000000000000000000000000e-3
 t=abs(s) =   1.240000000000000000000000000000e-3
*/
