/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

/*
    Test:  print_cxpr  cxprint  

    Uses:  print_cxpr  cxprint  xprint  atocx  

    Input file:  data/prcxpr.dat
*/

#include <stdio.h>
#include <stdlib.h>
#include "cxpre.h"

#define BUFF_SIZE 5120 /* 5 Kb */
int decd=30;

int main(int na,char **av)
{ 
  struct cxpr x;
  int i;
  char buffer [BUFF_SIZE];
  FILE *fp;

  if(na!=2)
    { 
      printf("para: input_file\n"); 
      exit(-1);
    }
  fp=fopen(*++av,"r");
  printf("     Test of Printing Functions\n");
  while( fgets(buffer, BUFF_SIZE, fp) != NULL )
    {
      for (i=0; buffer[i] != '\0'; i++);
      if ( i>0 && buffer[i-1] == '\n' )
	buffer[i-1] = '\0';
      printf ("buffer : %s\n", buffer);
      x = atocx (buffer);
      cxprint (stdout, x);
      xprint (stdout, x.re);
      xprint (stdout, x.im);
      print_cxpr (stdout, x, 0, 0, -1);
      print_cxpr (stdout, x, 0, 0,  6);
      print_cxpr (stdout, x, 0, 0,  decd);
      print_cxpr (stdout, x, 0, 0,  160);
      print_cxpr (stdout, x, 0, 1, -1);
      print_cxpr (stdout, x, 0, 1,  6);
      print_cxpr (stdout, x, 0, 1,  decd);
      print_cxpr (stdout, x, 0, 1,  160);
      print_cxpr (stdout, x, 1, 0, -1);
      print_cxpr (stdout, x, 1, 0,  6);
      print_cxpr (stdout, x, 1, 0,  decd);
      print_cxpr (stdout, x, 1, 0,  160);
      print_cxpr (stdout, x, 1, 1, -1);
      print_cxpr (stdout, x, 1, 1,  6);
      print_cxpr (stdout, x, 1, 1,  decd);
      print_cxpr (stdout, x, 1, 1,  160);
    }
  fclose (fp);
  return 0;
}

/*  Test output

     Test of Printing Functions
buffer : 0
(0000.0000000000000000000000000000 , 0000.0000000000000000000000000000)
0000.0000000000000000000000000000
0000.0000000000000000000000000000
0.+0.i
0.000000+0.000000i
0.000000000000000000000000000000+0.000000000000000000000000000000i
0.0000000000000000000000000000000000000+0.0000000000000000000000000000000000000i
+0.+0.i
+0.000000+0.000000i
+0.000000000000000000000000000000+0.000000000000000000000000000000i
+0.0000000000000000000000000000000000000+0.0000000000000000000000000000000000000i
0.e+0+0.e+0i
0.000000e+0+0.000000e+0i
0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
0.0000000000000000000000000000000000000e+0+0.0000000000000000000000000000000000000e+0i
+0.e+0+0.e+0i
+0.000000e+0+0.000000e+0i
+0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
+0.0000000000000000000000000000000000000e+0+0.0000000000000000000000000000000000000e+0i
buffer : +0.000000000987654321
(3fe1.87bdff4398f8e1e50eecf28df50c , 0000.0000000000000000000000000000)
3fe1.87bdff4398f8e1e50eecf28df50c
0000.0000000000000000000000000000
0.000000001+0.i
0.0000000009876543+0.000000i
0.0000000009876543210000000000000000000000+0.000000000000000000000000000000i
0.00000000098765432099999999999999999999997951303+0.0000000000000000000000000000000000000i
+0.000000001+0.i
+0.0000000009876543+0.000000i
+0.0000000009876543210000000000000000000000+0.000000000000000000000000000000i
+0.00000000098765432099999999999999999999997951303+0.0000000000000000000000000000000000000i
1.e-9+0.e+0i
9.876543e-10+0.000000e+0i
9.876543210000000000000000000000e-10+0.000000000000000000000000000000e+0i
9.8765432099999999999999999999997951303e-10+0.0000000000000000000000000000000000000e+0i
+1.e-9+0.e+0i
+9.876543e-10+0.000000e+0i
+9.876543210000000000000000000000e-10+0.000000000000000000000000000000e+0i
+9.8765432099999999999999999999997951303e-10+0.0000000000000000000000000000000000000e+0i
buffer : -0.0000987654321e-2
(bfeb.848f8b4803630c99b09364dea158 , 0000.0000000000000000000000000000)
bfeb.848f8b4803630c99b09364dea158
0000.0000000000000000000000000000
-0.000001+0.i
-0.0000009876543+0.000000i
-0.0000009876543210000000000000000000000+0.000000000000000000000000000000i
-0.00000098765432099999999999999999999998321081+0.0000000000000000000000000000000000000i
-0.000001+0.i
-0.0000009876543+0.000000i
-0.0000009876543210000000000000000000000+0.000000000000000000000000000000i
-0.00000098765432099999999999999999999998321081+0.0000000000000000000000000000000000000i
-1.e-6+0.e+0i
-9.876543e-7+0.000000e+0i
-9.876543210000000000000000000000e-7+0.000000000000000000000000000000e+0i
-9.8765432099999999999999999999998321081e-7+0.0000000000000000000000000000000000000e+0i
-1.e-6+0.e+0i
-9.876543e-7+0.000000e+0i
-9.876543210000000000000000000000e-7+0.000000000000000000000000000000e+0i
-9.8765432099999999999999999999998321081e-7+0.0000000000000000000000000000000000000e+0i
buffer : 103256.12E+2
(4016.9d8e6c0000000000000000000000 , 0000.0000000000000000000000000000)
4016.9d8e6c0000000000000000000000
0000.0000000000000000000000000000
10000000+0.i
10325610+0.000000i
10325612.00000000000000000000000+0.000000000000000000000000000000i
10325611.999999999999999999999999920286+0.0000000000000000000000000000000000000i
+10000000+0.i
+10325610+0.000000i
+10325612.00000000000000000000000+0.000000000000000000000000000000i
+10325611.999999999999999999999999920286+0.0000000000000000000000000000000000000i
1.e+7+0.e+0i
1.032561e+7+0.000000e+0i
1.032561200000000000000000000000e+7+0.000000000000000000000000000000e+0i
1.0325611999999999999999999999999920286e+7+0.0000000000000000000000000000000000000e+0i
+1.e+7+0.e+0i
+1.032561e+7+0.000000e+0i
+1.032561200000000000000000000000e+7+0.000000000000000000000000000000e+0i
+1.0325611999999999999999999999999920286e+7+0.0000000000000000000000000000000000000e+0i
buffer : -987654321000123456789.008
(c044.d629d41087efef7454083126e978 , 0000.0000000000000000000000000000)
c044.d629d41087efef7454083126e978
0000.0000000000000000000000000000
-1000000000000000000000+0.i
-987654300000000000000+0.000000i
-987654321000123456789.0080000000+0.000000000000000000000000000000i
-987654321000123456789.00799999997551894+0.0000000000000000000000000000000000000i
-1000000000000000000000+0.i
-987654300000000000000+0.000000i
-987654321000123456789.0080000000+0.000000000000000000000000000000i
-987654321000123456789.00799999997551894+0.0000000000000000000000000000000000000i
-1.e+21+0.e+0i
-9.876543e+20+0.000000e+0i
-9.876543210001234567890080000000e+20+0.000000000000000000000000000000e+0i
-9.8765432100012345678900799999997551894e+20+0.0000000000000000000000000000000000000e+0i
-1.e+21+0.e+0i
-9.876543e+20+0.000000e+0i
-9.876543210001234567890080000000e+20+0.000000000000000000000000000000e+0i
-9.8765432100012345678900799999997551894e+20+0.0000000000000000000000000000000000000e+0i
buffer : 0i
(0000.0000000000000000000000000000 , 0000.0000000000000000000000000000)
0000.0000000000000000000000000000
0000.0000000000000000000000000000
0.+0.i
0.000000+0.000000i
0.000000000000000000000000000000+0.000000000000000000000000000000i
0.0000000000000000000000000000000000000+0.0000000000000000000000000000000000000i
+0.+0.i
+0.000000+0.000000i
+0.000000000000000000000000000000+0.000000000000000000000000000000i
+0.0000000000000000000000000000000000000+0.0000000000000000000000000000000000000i
0.e+0+0.e+0i
0.000000e+0+0.000000e+0i
0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
0.0000000000000000000000000000000000000e+0+0.0000000000000000000000000000000000000e+0i
+0.e+0+0.e+0i
+0.000000e+0+0.000000e+0i
+0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
+0.0000000000000000000000000000000000000e+0+0.0000000000000000000000000000000000000e+0i
buffer : +0.000000000987654321i
(0000.0000000000000000000000000000 , 3fe1.87bdff4398f8e1e50eecf28df50c)
0000.0000000000000000000000000000
3fe1.87bdff4398f8e1e50eecf28df50c
0.+0.000000001i
0.000000+0.0000000009876543i
0.000000000000000000000000000000+0.0000000009876543210000000000000000000000i
0.0000000000000000000000000000000000000+0.00000000098765432099999999999999999999997951303i
+0.+0.000000001i
+0.000000+0.0000000009876543i
+0.000000000000000000000000000000+0.0000000009876543210000000000000000000000i
+0.0000000000000000000000000000000000000+0.00000000098765432099999999999999999999997951303i
0.e+0+1.e-9i
0.000000e+0+9.876543e-10i
0.000000000000000000000000000000e+0+9.876543210000000000000000000000e-10i
0.0000000000000000000000000000000000000e+0+9.8765432099999999999999999999997951303e-10i
+0.e+0+1.e-9i
+0.000000e+0+9.876543e-10i
+0.000000000000000000000000000000e+0+9.876543210000000000000000000000e-10i
+0.0000000000000000000000000000000000000e+0+9.8765432099999999999999999999997951303e-10i
buffer : -0.0000987654321e-2i
(0000.0000000000000000000000000000 , bfeb.848f8b4803630c99b09364dea158)
0000.0000000000000000000000000000
bfeb.848f8b4803630c99b09364dea158
0.-0.000001i
0.000000-0.0000009876543i
0.000000000000000000000000000000-0.0000009876543210000000000000000000000i
0.0000000000000000000000000000000000000-0.00000098765432099999999999999999999998321081i
+0.-0.000001i
+0.000000-0.0000009876543i
+0.000000000000000000000000000000-0.0000009876543210000000000000000000000i
+0.0000000000000000000000000000000000000-0.00000098765432099999999999999999999998321081i
0.e+0-1.e-6i
0.000000e+0-9.876543e-7i
0.000000000000000000000000000000e+0-9.876543210000000000000000000000e-7i
0.0000000000000000000000000000000000000e+0-9.8765432099999999999999999999998321081e-7i
+0.e+0-1.e-6i
+0.000000e+0-9.876543e-7i
+0.000000000000000000000000000000e+0-9.876543210000000000000000000000e-7i
+0.0000000000000000000000000000000000000e+0-9.8765432099999999999999999999998321081e-7i
buffer : 103256.12E+2i
(0000.0000000000000000000000000000 , 4016.9d8e6c0000000000000000000000)
0000.0000000000000000000000000000
4016.9d8e6c0000000000000000000000
0.+10000000i
0.000000+10325610i
0.000000000000000000000000000000+10325612.00000000000000000000000i
0.0000000000000000000000000000000000000+10325611.999999999999999999999999920286i
+0.+10000000i
+0.000000+10325610i
+0.000000000000000000000000000000+10325612.00000000000000000000000i
+0.0000000000000000000000000000000000000+10325611.999999999999999999999999920286i
0.e+0+1.e+7i
0.000000e+0+1.032561e+7i
0.000000000000000000000000000000e+0+1.032561200000000000000000000000e+7i
0.0000000000000000000000000000000000000e+0+1.0325611999999999999999999999999920286e+7i
+0.e+0+1.e+7i
+0.000000e+0+1.032561e+7i
+0.000000000000000000000000000000e+0+1.032561200000000000000000000000e+7i
+0.0000000000000000000000000000000000000e+0+1.0325611999999999999999999999999920286e+7i
buffer : -987654321000123456789.008i
(0000.0000000000000000000000000000 , c044.d629d41087efef7454083126e978)
0000.0000000000000000000000000000
c044.d629d41087efef7454083126e978
0.-1000000000000000000000i
0.000000-987654300000000000000i
0.000000000000000000000000000000-987654321000123456789.0080000000i
0.0000000000000000000000000000000000000-987654321000123456789.00799999997551894i
+0.-1000000000000000000000i
+0.000000-987654300000000000000i
+0.000000000000000000000000000000-987654321000123456789.0080000000i
+0.0000000000000000000000000000000000000-987654321000123456789.00799999997551894i
0.e+0-1.e+21i
0.000000e+0-9.876543e+20i
0.000000000000000000000000000000e+0-9.876543210001234567890080000000e+20i
0.0000000000000000000000000000000000000e+0-9.8765432100012345678900799999997551894e+20i
+0.e+0-1.e+21i
+0.000000e+0-9.876543e+20i
+0.000000000000000000000000000000e+0-9.876543210001234567890080000000e+20i
+0.0000000000000000000000000000000000000e+0-9.8765432100012345678900799999997551894e+20i
buffer : 0         +0.0i
(0000.0000000000000000000000000000 , 0000.0000000000000000000000000000)
0000.0000000000000000000000000000
0000.0000000000000000000000000000
0.+0.i
0.000000+0.000000i
0.000000000000000000000000000000+0.000000000000000000000000000000i
0.0000000000000000000000000000000000000+0.0000000000000000000000000000000000000i
+0.+0.i
+0.000000+0.000000i
+0.000000000000000000000000000000+0.000000000000000000000000000000i
+0.0000000000000000000000000000000000000+0.0000000000000000000000000000000000000i
0.e+0+0.e+0i
0.000000e+0+0.000000e+0i
0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
0.0000000000000000000000000000000000000e+0+0.0000000000000000000000000000000000000e+0i
+0.e+0+0.e+0i
+0.000000e+0+0.000000e+0i
+0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
+0.0000000000000000000000000000000000000e+0+0.0000000000000000000000000000000000000e+0i
buffer : 0.000     -0i
(0000.0000000000000000000000000000 , 0000.0000000000000000000000000000)
0000.0000000000000000000000000000
0000.0000000000000000000000000000
0.+0.i
0.000000+0.000000i
0.000000000000000000000000000000+0.000000000000000000000000000000i
0.0000000000000000000000000000000000000+0.0000000000000000000000000000000000000i
+0.+0.i
+0.000000+0.000000i
+0.000000000000000000000000000000+0.000000000000000000000000000000i
+0.0000000000000000000000000000000000000+0.0000000000000000000000000000000000000i
0.e+0+0.e+0i
0.000000e+0+0.000000e+0i
0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
0.0000000000000000000000000000000000000e+0+0.0000000000000000000000000000000000000e+0i
+0.e+0+0.e+0i
+0.000000e+0+0.000000e+0i
+0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
+0.0000000000000000000000000000000000000e+0+0.0000000000000000000000000000000000000e+0i
buffer : 2.876     +4.567i
(4000.b810624dd2f1a9fbe76c8b43957d , 4001.9224dd2f1a9fbe76c8b439581061)
4000.b810624dd2f1a9fbe76c8b43957d
4001.9224dd2f1a9fbe76c8b439581061
3+5i
2.876000+4.567000i
2.876000000000000000000000000000+4.567000000000000000000000000000i
2.8759999999999999999999999999999967459+4.5669999999999999999999999999999979909i
+3+5i
+2.876000+4.567000i
+2.876000000000000000000000000000+4.567000000000000000000000000000i
+2.8759999999999999999999999999999967459+4.5669999999999999999999999999999979909i
3.e+0+5.e+0i
2.876000e+0+4.567000e+0i
2.876000000000000000000000000000e+0+4.567000000000000000000000000000e+0i
2.8759999999999999999999999999999967459e+0+4.5669999999999999999999999999999979909e+0i
+3.e+0+5.e+0i
+2.876000e+0+4.567000e+0i
+2.876000000000000000000000000000e+0+4.567000000000000000000000000000e+0i
+2.8759999999999999999999999999999967459e+0+4.5669999999999999999999999999999979909e+0i
buffer : -5.44     +3.567e+2i
(c001.ae147ae147ae147ae147ae147ae0 , 4007.b259999999999999999999999999)
c001.ae147ae147ae147ae147ae147ae0
4007.b259999999999999999999999999
-5+400i
-5.440000+356.7000i
-5.440000000000000000000000000000+356.7000000000000000000000000000i
-5.4399999999999999999999999999999980278+356.69999999999999999999999999999910575i
-5+400i
-5.440000+356.7000i
-5.440000000000000000000000000000+356.7000000000000000000000000000i
-5.4399999999999999999999999999999980278+356.69999999999999999999999999999910575i
-5.e+0+4.e+2i
-5.440000e+0+3.567000e+2i
-5.440000000000000000000000000000e+0+3.567000000000000000000000000000e+2i
-5.4399999999999999999999999999999980278e+0+3.5669999999999999999999999999999910575e+2i
-5.e+0+4.e+2i
-5.440000e+0+3.567000e+2i
-5.440000000000000000000000000000e+0+3.567000000000000000000000000000e+2i
-5.4399999999999999999999999999999980278e+0+3.5669999999999999999999999999999910575e+2i
buffer : -8.992e+3 -782.654E-1i
(c00c.8c80000000000000000000000000 , c005.9c87e28240b780346dc5d6388657)
c00c.8c80000000000000000000000000
c005.9c87e28240b780346dc5d6388657
-9000-80i
-8992.000-78.26540i
-8992.000000000000000000000000000-78.26540000000000000000000000000i
-8991.9999999999999999999999999999631701-78.265399999999999999999999999999764752i
-9000-80i
-8992.000-78.26540i
-8992.000000000000000000000000000-78.26540000000000000000000000000i
-8991.9999999999999999999999999999631701-78.265399999999999999999999999999764752i
-9.e+3-8.e+1i
-8.992000e+3-7.826540e+1i
-8.992000000000000000000000000000e+3-7.826540000000000000000000000000e+1i
-8.9919999999999999999999999999999631701e+3-7.8265399999999999999999999999999764752e+1i
-9.e+3-8.e+1i
-8.992000e+3-7.826540e+1i
-8.992000000000000000000000000000e+3-7.826540000000000000000000000000e+1i
-8.9919999999999999999999999999999631701e+3-7.8265399999999999999999999999999764752e+1i
buffer : +8.921E2  -65443.28E-1i
(4008.df06666666666666666666666666 , c00b.cc829fbe76c8b4395810624dd2f0)
4008.df06666666666666666666666666
c00b.cc829fbe76c8b4395810624dd2f0
900-7000i
892.1000-6544.328i
892.1000000000000000000000000000-6544.328000000000000000000000000i
892.09999999999999999999999999999698754-6544.3279999999999999999999999999744977i
+900-7000i
+892.1000-6544.328i
+892.1000000000000000000000000000-6544.328000000000000000000000000i
+892.09999999999999999999999999999698754-6544.3279999999999999999999999999744977i
9.e+2-7.e+3i
8.921000e+2-6.544328e+3i
8.921000000000000000000000000000e+2-6.544328000000000000000000000000e+3i
8.9209999999999999999999999999999698754e+2-6.5443279999999999999999999999999744977e+3i
+9.e+2-7.e+3i
+8.921000e+2-6.544328e+3i
+8.921000000000000000000000000000e+2-6.544328000000000000000000000000e+3i
+8.9209999999999999999999999999999698754e+2-6.5443279999999999999999999999999744977e+3i
buffer : +9.776E13 -8.566212e-8i
(402d.b1d30c2580000000000000000000 , bfe7.b7f53f9db1b2bf0f4156281b4a61)
402d.b1d30c2580000000000000000000
bfe7.b7f53f9db1b2bf0f4156281b4a61
100000000000000-0.00000009i
97760000000000-0.00000008566212i
97760000000000.00000000000000000-0.00000008566212000000000000000000000000i
97759999999999.999999999999999998439041-0.000000085662119999999999999999999999999196894i
+100000000000000-0.00000009i
+97760000000000-0.00000008566212i
+97760000000000.00000000000000000-0.00000008566212000000000000000000000000i
+97759999999999.999999999999999998439041-0.000000085662119999999999999999999999999196894i
1.e+14-9.e-8i
9.776000e+13-8.566212e-8i
9.776000000000000000000000000000e+13-8.566212000000000000000000000000e-8i
9.7759999999999999999999999999998439041e+13-8.5662119999999999999999999999999196894e-8i
+1.e+14-9.e-8i
+9.776000e+13-8.566212e-8i
+9.776000000000000000000000000000e+13-8.566212000000000000000000000000e-8i
+9.7759999999999999999999999999998439041e+13-8.5662119999999999999999999999999196894e-8i
buffer : -87.65421 -3245.678E+12i
(c005.af4ef49cf56eac8605681ecd4aa0 , c032.b87ed4c3ecc00000000000000000)
c005.af4ef49cf56eac8605681ecd4aa0
c032.b87ed4c3ecc00000000000000000
-90-3000000000000000i
-87.65421-3245678000000000i
-87.65421000000000000000000000000-3245678000000000.000000000000000i
-87.654209999999999999999999999999770621-3245677999999999.9999999999999999455453i
-90-3000000000000000i
-87.65421-3245678000000000i
-87.65421000000000000000000000000-3245678000000000.000000000000000i
-87.654209999999999999999999999999770621-3245677999999999.9999999999999999455453i
-9.e+1-3.e+15i
-8.765421e+1-3.245678e+15i
-8.765421000000000000000000000000e+1-3.245678000000000000000000000000e+15i
-8.7654209999999999999999999999999770621e+1-3.2456779999999999999999999999999455453e+15i
-9.e+1-3.e+15i
-8.765421e+1-3.245678e+15i
-8.765421000000000000000000000000e+1-3.245678000000000000000000000000e+15i
-8.7654209999999999999999999999999770621e+1-3.2456779999999999999999999999999455453e+15i
*/
