/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

/*
    Test:  cxpwr  cxroot

    Uses:  cxpwr  cxroot  str2cx  print_cxpr

    Input file:  data/cxpwr.dat
*/
#include<stdio.h>
#include<stdlib.h>
#include"cxpre.h"

#define DECD 32

int getline (char* buffer, int size, FILE* fp)
{
  if ( (fgets (buffer, size, fp)) )
    {
      int i;

      for (i=0; buffer[i] != '\0'; i++);
      if ( i > 0 && buffer[i-1] == '\n' )
	buffer[--i] = '\0';
      return i;
    }
  else
    return -1;
}

extern int xerrno;

int main(int na,char **av)
{ 
  struct cxpr z, w;
  FILE *fp;
  char num[1024], *re, *im, *endptr;
  int n, i;

  if(na!=2)
    { 
      printf("para: input_file\n");
      exit(-1);
    }
  fp=fopen(*++av,"r");
  /* Test of cxpwr() */
  printf ("\nTest of cxpwr()\n");
  while( getline(num, 1024, fp) != -1 )
    {
      printf("*string in : \t%s\n", num);
      /* convert ascii string to extended precision complex */
      z= str2cx (num, &endptr);
      re = asprint_xpr (z.re, 1, 0, DECD);
      im = asprint_xpr (z.im, 1, 0, DECD);
      printf(" z =  \t\t%s  \t%s\n", re, im); 
      free ((void*)re); free ((void*)im);
      n = atoi (endptr);
      printf(" n = %d\n", n);
      printf(" cxpwr(z,n) = \t");
      xerrno = 0;
      w = cxpwr(z, n);
      switch (xerrno)
	{
	case XENONE:
	  re = asprint_xpr (w.re, 1, 0, DECD);
	  im = asprint_xpr (w.im, 1, 0, DECD);
	  printf("%s  \t%s\n", re, im);
	  free ((void*)re); free ((void*)im);
	  break;
	case XEDIV:
	  printf ("*** Division by zero\n");
	  break;
	case XEDOM:
	  printf ("*** Out of domain\n");
	  break;
	case XEBADEXP:
	  printf ("*** Bad exponent\n");
	  break;
	case XFPOFLOW:
	  printf ("*** Floating point overflow\n");
	  break;
	default:
	  printf ("*** Unknown error\n");
	}
    }
  rewind (fp);
  /* Test of cxroot() */
  printf ("\nTest of cxroot()\n");
  while( getline(num, 1024, fp) != -1 )
    {
      printf("*string in : \t%s\n", num);
      /* convert ascii string to extended precision complex */
      z= str2cx (num, &endptr);
      re = asprint_xpr (z.re, 1, 0, DECD);
      im = asprint_xpr (z.im, 1, 0, DECD);
      printf(" z =  \t\t%s  \t%s\n", re, im); 
      free ((void*)re); free ((void*)im);
      n = atoi (endptr);
      printf(" n = %d\n", n);
      for (i=0; i<= abs(n); i++)
	{
	  printf(" cxroot(z,%d,n) = \t", i);
	  xerrno = 0;
	  w = cxroot(z, i, n);
	  switch (xerrno)
	    {
	    case XENONE:
	      re = asprint_xpr (w.re, 1, 0, DECD);
	      im = asprint_xpr (w.im, 1, 0, DECD);
	      printf("%s  \t%s\n", re, im);
	      free ((void*)re); free ((void*)im);
	      break;
	    case XEDIV:
	      printf ("*** Division by zero\n");
	      break;
	    case XEDOM:
	      printf ("*** Out of domain\n");
	      break;
	    case XEBADEXP:
	      printf ("*** Bad exponent\n");
	      break;
	    case XFPOFLOW:
	      printf ("*** Floating point overflow\n");
	      break;
	    default:
	      printf ("*** Unknown error\n");
	    }
	}
    }
  fclose (fp);
  return 0;
}

/*  Test output


Test of cxpwr()
*string in : 	0    +0.00i	 	 	 1
 z =  		0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 n = 1
 cxpwr(z,n) = 	0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
*string in : 	0    +0.00i	 	 	 0
 z =  		0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 n = 0
 cxpwr(z,n) = 	*** Bad exponent
*string in : 	0.00 +0i			-1
 z =  		0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 n = -1
 cxpwr(z,n) = 	*** Bad exponent
*string in : 	1.0e-2500  +2.5e-2601i	 	 0
 z =  		9.99999999999999999999999999997044e-2501  	2.49999999999999999999999999999231e-2601
 n = 0
 cxpwr(z,n) = 	1.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
*string in : 	1.0e-2500  +2.5e-2601i	 	 2
 z =  		9.99999999999999999999999999997044e-2501  	2.49999999999999999999999999999231e-2601
 n = 2
 cxpwr(z,n) = 	0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
*string in : 	1.0e-2500  +2.5e-2601i		-4
 z =  		9.99999999999999999999999999997044e-2501  	2.49999999999999999999999999999231e-2601
 n = -4
 cxpwr(z,n) = 	*** Floating point overflow
*string in : 	1.21e-2134 +3.709e-2291i  	 0
 z =  		1.20999999999999999999999999999695e-2134  	3.70899999999999999999999999998995e-2291
 n = 0
 cxpwr(z,n) = 	1.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
*string in : 	1.21e-2134 +3.709e-2291i  	 3
 z =  		1.20999999999999999999999999999695e-2134  	3.70899999999999999999999999998995e-2291
 n = 3
 cxpwr(z,n) = 	0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
*string in : 	1.21e-2134 +3.709e-2291i 	-5
 z =  		1.20999999999999999999999999999695e-2134  	3.70899999999999999999999999998995e-2291
 n = -5
 cxpwr(z,n) = 	*** Floating point overflow
*string in : 	7.664e-561 -4.823e-621i		 0
 z =  		7.66399999999999999999999999999492e-561  	-4.82299999999999999999999999999646e-621
 n = 0
 cxpwr(z,n) = 	1.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
*string in : 	7.664e-561 -4.823e-621i		 2
 z =  		7.66399999999999999999999999999492e-561  	-4.82299999999999999999999999999646e-621
 n = 2
 cxpwr(z,n) = 	5.87368959999999999999999999999221e-1121  	-7.39269439999999999999999999998967e-1181
*string in : 	7.664e-561 -4.823e-621i		-6
 z =  		7.66399999999999999999999999999492e-561  	-4.82299999999999999999999999999646e-621
 n = -6
 cxpwr(z,n) = 	4.93477122397092486617623492180171e+3360  	1.86328822650405302423548912013436e+3301
*string in : 	-6.742e-32 +5.418e-28i		 0
 z =  		-6.74199999999999999999999999999975e-32  	5.41799999999999999999999999999982e-28
 n = 0
 cxpwr(z,n) = 	1.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
*string in : 	-6.742e-32 +5.418e-28i		 5
 z =  		-6.74199999999999999999999999999975e-32  	5.41799999999999999999999999999982e-28
 n = 5
 cxpwr(z,n) = 	-2.90479000702370672843578120794929e-140  	4.66868890788035842916196045712928e-137
*string in : 	-6.742e-32 +5.418e-28i		-7
 z =  		-6.74199999999999999999999999999975e-32  	5.41799999999999999999999999999982e-28
 n = -7
 cxpwr(z,n) = 	6.35586555323825052969248236540341e+187  	7.29670530910529060028039371698939e+190
*string in : 	3.445      +9.751i		 0
 z =  		3.44500000000000000000000000000000e+0  	9.75099999999999999999999999999998e+0
 n = 0
 cxpwr(z,n) = 	1.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
*string in : 	3.445      +9.751i		 1
 z =  		3.44500000000000000000000000000000e+0  	9.75099999999999999999999999999998e+0
 n = 1
 cxpwr(z,n) = 	3.44500000000000000000000000000001e+0  	9.75099999999999999999999999999998e+0
*string in : 	3.445      +9.751i		 8
 z =  		3.44500000000000000000000000000000e+0  	9.75099999999999999999999999999998e+0
 n = 8
 cxpwr(z,n) = 	-1.19210751005636224553020666179822e+8  	-5.39125739333460751897285133145588e+7
*string in : 	3.445      +9.751i		-3
 z =  		3.44500000000000000000000000000000e+0  	9.75099999999999999999999999999998e+0
 n = -3
 cxpwr(z,n) = 	-7.69857012022053940518509196267983e-4  	4.74091631323149424143568340974419e-4
*string in : 	-8.90      +0.532i		-2
 z =  		-8.89999999999999999999999999999998e+0  	5.31999999999999999999999999999998e-1
 n = -2
 cxpwr(z,n) = 	1.24901434689238398364016071120271e-2  	1.49855814307799140454574946223773e-3
*string in : 	-8.90      +0.532i		 4
 z =  		-8.89999999999999999999999999999998e+0  	5.31999999999999999999999999999998e-1
 n = 4
 cxpwr(z,n) = 	6.13979421634457599999999999999996e+3  	-1.49481378385919999999999999999997e+3
*string in : 	-7.772     +0.0i		 2
 z =  		-7.77200000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 n = 2
 cxpwr(z,n) = 	6.04039839999999999999999999999999e+1  	0.00000000000000000000000000000000e-4931
*string in : 	-7.772     +0.0i		 3
 z =  		-7.77200000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 n = 3
 cxpwr(z,n) = 	-4.69459763647999999999999999999998e+2  	0.00000000000000000000000000000000e-4930
*string in : 	-7.772     +0.0i		-5
 z =  		-7.77200000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 n = -5
 cxpwr(z,n) = 	-3.52643627576212680223718773800489e-5  	0.00000000000000000000000000000000e+0
*string in : 	+82.06126  +0i			-1
 z =  		8.20612599999999999999999999999998e+1  	0.00000000000000000000000000000000e+0
 n = -1
 cxpwr(z,n) = 	1.21860181040359360799480778140623e-2  	0.00000000000000000000000000000000e+0
*string in : 	+82.06126  +0i			 7
 z =  		8.20612599999999999999999999999998e+1  	0.00000000000000000000000000000000e+0
 n = 7
 cxpwr(z,n) = 	2.50592037363291607837155265799731e+13  	0.00000000000000000000000000000000e-4919
*string in : 	-88.7665   -7.432i		-4
 z =  		-8.87664999999999999999999999999998e+1  	-7.43200000000000000000000000000000e+0
 n = -4
 cxpwr(z,n) = 	1.50047723950547730649094886266823e-8  	-5.20870930560197234487095379323366e-9
*string in : 	-88.7665   -7.432i		 6
 z =  		-8.87664999999999999999999999999998e+1  	-7.43200000000000000000000000000000e+0
 n = 6
 cxpwr(z,n) = 	4.38129804223485246172082306627384e+11  	2.40024703440847563633540725123496e+11
*string in : 	+9.4332    -67.5584i		-1
 z =  		9.43319999999999999999999999999999e+0  	-6.75583999999999999999999999999998e+1
 n = -1
 cxpwr(z,n) = 	2.02728375401364724578855508913374e-3  	1.45189380875159634153714031435496e-2
*string in : 	+9.4332    -67.5584i		 3
 z =  		9.43319999999999999999999999999999e+0  	-6.75583999999999999999999999999998e+1
 n = 3
 cxpwr(z,n) = 	-1.28323847288121407999999999999999e+5  	2.90310715016032255999999999999997e+5
*string in : 	+9.4332    -67.5584i		-6
 z =  		9.43319999999999999999999999999999e+0  	-6.75583999999999999999999999999998e+1
 n = -6
 cxpwr(z,n) = 	-6.68109850607085220278532306828402e-12  	7.34063144012444518680789174827083e-12
*string in : 	8765.9431      +0i		 0
 z =  		8.76594309999999999999999999999996e+3  	0.00000000000000000000000000000000e+0
 n = 0
 cxpwr(z,n) = 	1.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
*string in : 	8765.9431      +0i		-2
 z =  		8.76594309999999999999999999999996e+3  	0.00000000000000000000000000000000e+0
 n = -2
 cxpwr(z,n) = 	1.30137573683876658117913991877986e-8  	0.00000000000000000000000000000000e+0
*string in : 	8765.9431      +0i		 5
 z =  		8.76594309999999999999999999999996e+3  	0.00000000000000000000000000000000e+0
 n = 5
 cxpwr(z,n) = 	5.17598771096611818114274172099114e+19  	0.00000000000000000000000000000000e-4913
*string in : 	8999.432192e+8 +3.042e+12i	 1
 z =  		8.99943219199999999999999999999988e+11  	3.04199999999999999999999999999996e+12
 n = 1
 cxpwr(z,n) = 	8.99943219199999999999999999999990e+11  	3.04199999999999999999999999999995e+12
*string in : 	8999.432192e+8 +3.042e+12i	-4
 z =  		8.99943219199999999999999999999988e+11  	3.04199999999999999999999999999996e+12
 n = -4
 cxpwr(z,n) = 	4.02847856781542796508534447411239e-51  	9.01470501086724845712102125559825e-51
*string in : 	8999.432192e+8 +3.042e+12i	 6
 z =  		8.99943219199999999999999999999988e+11  	3.04199999999999999999999999999996e+12
 n = 6
 cxpwr(z,n) = 	1.57362935207057037899948465243708e+74  	1.00699905356002098378146925838470e+75
*string in : 	0  +6.7891e+24i			-1
 z =  		0.00000000000000000000000000000000e+0  	6.78909999999999999999999999999981e+24
 n = -1
 cxpwr(z,n) = 	0.00000000000000000000000000000000e+0  	-1.47294928635607076048371654563933e-25
*string in : 	0  +6.7891e+24i		 	 4
 z =  		0.00000000000000000000000000000000e+0  	6.78909999999999999999999999999981e+24
 n = 4
 cxpwr(z,n) = 	2.12446129223572701609999999999976e+99  	0.00000000000000000000000000000000e-4833
*string in : 	0  +6.7891e+24i			-5
 z =  		0.00000000000000000000000000000000e+0  	6.78909999999999999999999999999981e+24
 n = -5
 cxpwr(z,n) = 	0.00000000000000000000000000000000e+0  	-6.93328370697673569324641420640480e-125
*string in : 	-6.5571e+101	+5.667e+101i	 2
 z =  		-6.55709999999999999999999999999921e+101  	5.66699999999999999999999999999932e+101
 n = 2
 cxpwr(z,n) = 	1.08806714099999999999999999999974e+203  	-7.43181713999999999999999999999821e+203
*string in : 	-6.5571e+101	+5.667e+101i	-6
 z =  		-6.55709999999999999999999999999921e+101  	5.66699999999999999999999999999932e+101
 n = -6
 cxpwr(z,n) = 	-9.96897851137280862136441438678516e-613  	-2.13903227666470663183868135589447e-612
*string in : 	-6.5571e+101	+5.667e+101i	 7
 z =  		-6.55709999999999999999999999999921e+101  	5.66699999999999999999999999999932e+101
 n = 7
 cxpwr(z,n) = 	-1.00285003634113464182469698439966e+713  	-3.53283077056903890428167089055837e+713
*string in : 	0		-8.88165e+152i	+8
 z =  		0.00000000000000000000000000000000e+0  	-8.88164999999999999999999999999840e+152
 n = 8
 cxpwr(z,n) = 	3.87212384426447405346650496980991e+1223  	-0.00000000000000000000000000000000e-3709
*string in : 	0		-8.88165e+152i	-9
 z =  		0.00000000000000000000000000000000e+0  	-8.88164999999999999999999999999840e+152
 n = -9
 cxpwr(z,n) = 	7.28016033139821353145770218703641e-1410  	2.90775027833452413473572384800434e-1377
*string in : 	-544.678e+503	-897.654e+502i	 3
 z =  		-5.44677999999999999999999999999674e+505  	-8.97653999999999999999999999999465e+504
 n = 3
 cxpwr(z,n) = 	-1.48425104995115048559999999999734e+1517  	-7.91699000793097185359999999998581e+1516
*string in : 	-544.678e+503	-897.654e+502i	-5
 z =  		-5.44677999999999999999999999999674e+505  	-8.97653999999999999999999999999465e+504
 n = -5
 cxpwr(z,n) = 	-1.33557912978097898258562752980539e-2529  	1.42186976255705365124877785580152e-2529
*string in : 	-544.678e+503	-897.654e+502i	13
 z =  		-5.44677999999999999999999999999674e+505  	-8.97653999999999999999999999999465e+504
 n = 13
 cxpwr(z,n) = 	*** Floating point overflow
*string in : 	6557.821e+2456  -76.671e+2511i	-2
 z =  		6.55782099999999999999999999998092e+2459  	-7.66709999999999999999999999997722e+2512
 n = -2
 cxpwr(z,n) = 	0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
*string in : 	6557.821e+2456  -76.671e+2511i -17
 z =  		6.55782099999999999999999999998092e+2459  	-7.66709999999999999999999999997722e+2512
 n = -17
 cxpwr(z,n) = 	0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0

Test of cxroot()
*string in : 	0    +0.00i	 	 	 1
 z =  		0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 n = 1
 cxroot(z,0,n) = 	0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 cxroot(z,1,n) = 	0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
*string in : 	0    +0.00i	 	 	 0
 z =  		0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 n = 0
 cxroot(z,0,n) = 	*** Bad exponent
*string in : 	0.00 +0i			-1
 z =  		0.00000000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 n = -1
 cxroot(z,0,n) = 	*** Bad exponent
 cxroot(z,1,n) = 	*** Bad exponent
*string in : 	1.0e-2500  +2.5e-2601i	 	 0
 z =  		9.99999999999999999999999999997044e-2501  	2.49999999999999999999999999999231e-2601
 n = 0
 cxroot(z,0,n) = 	*** Bad exponent
*string in : 	1.0e-2500  +2.5e-2601i	 	 2
 z =  		9.99999999999999999999999999997044e-2501  	2.49999999999999999999999999999231e-2601
 n = 2
 cxroot(z,0,n) = 	1.00000000000000000000000000000280e-1250  	1.25000000000000000000000000000334e-1351
 cxroot(z,1,n) = 	-1.00000000000000000000000000000280e-1250  	-1.25000000000000000000000000000334e-1351
 cxroot(z,2,n) = 	1.00000000000000000000000000000280e-1250  	1.25000000000000000000000000000334e-1351
*string in : 	1.0e-2500  +2.5e-2601i		-4
 z =  		9.99999999999999999999999999997044e-2501  	2.49999999999999999999999999999231e-2601
 n = -4
 cxroot(z,0,n) = 	9.99999999999999999999999999997862e+624  	-6.24999999999999999999999999998663e+523
 cxroot(z,1,n) = 	-6.24999999999999999999999999998663e+523  	-9.99999999999999999999999999997862e+624
 cxroot(z,2,n) = 	-9.99999999999999999999999999997862e+624  	6.24999999999999999999999999998663e+523
 cxroot(z,3,n) = 	6.24999999999999999999999999998663e+523  	9.99999999999999999999999999997862e+624
 cxroot(z,4,n) = 	9.99999999999999999999999999997862e+624  	-6.24999999999999999999999999998663e+523
*string in : 	1.21e-2134 +3.709e-2291i  	 0
 z =  		1.20999999999999999999999999999695e-2134  	3.70899999999999999999999999998995e-2291
 n = 0
 cxroot(z,0,n) = 	*** Bad exponent
*string in : 	1.21e-2134 +3.709e-2291i  	 3
 z =  		1.20999999999999999999999999999695e-2134  	3.70899999999999999999999999998995e-2291
 n = 3
 cxroot(z,0,n) = 	4.94608744324870086832360365754836e-712  	5.05372956666926488171136252502574e-869
 cxroot(z,1,n) = 	-2.47304372162435043416180182877417e-712  	4.28343737519259793947345312732658e-712
 cxroot(z,2,n) = 	-2.47304372162435043416180182877421e-712  	-4.28343737519259793947345312732655e-712
 cxroot(z,3,n) = 	4.94608744324870086832360365754836e-712  	5.05372956666926488171136252502574e-869
*string in : 	1.21e-2134 +3.709e-2291i 	-5
 z =  		1.20999999999999999999999999999695e-2134  	3.70899999999999999999999999998995e-2291
 n = -5
 cxroot(z,0,n) = 	6.07355440249823459192641534113360e+426  	-3.72344021138280200024050818186190e+269
 cxroot(z,1,n) = 	1.87683152663273412226577439698040e+426  	-5.77629349156906396448909859207883e+426
 cxroot(z,2,n) = 	-4.91360872788185141822898206754719e+426  	-3.56994570678448571044561408834746e+426
 cxroot(z,3,n) = 	-4.91360872788185141822898206754722e+426  	3.56994570678448571044561408834741e+426
 cxroot(z,4,n) = 	1.87683152663273412226577439698036e+426  	5.77629349156906396448909859207884e+426
 cxroot(z,5,n) = 	6.07355440249823459192641534113360e+426  	-3.72344021138280200024050818186190e+269
*string in : 	7.664e-561 -4.823e-621i		 0
 z =  		7.66399999999999999999999999999492e-561  	-4.82299999999999999999999999999646e-621
 n = 0
 cxroot(z,0,n) = 	*** Bad exponent
*string in : 	7.664e-561 -4.823e-621i		 2
 z =  		7.66399999999999999999999999999492e-561  	-4.82299999999999999999999999999646e-621
 n = 2
 cxroot(z,0,n) = 	8.75442745129571566089802485747795e-281  	-2.75460618460329049011685633400399e-341
 cxroot(z,1,n) = 	-8.75442745129571566089802485747795e-281  	2.75460618460329049011685633400399e-341
 cxroot(z,2,n) = 	8.75442745129571566089802485747795e-281  	-2.75460618460329049011685633400399e-341
*string in : 	7.664e-561 -4.823e-621i		-6
 z =  		7.66399999999999999999999999999492e-561  	-4.82299999999999999999999999999646e-621
 n = -6
 cxroot(z,0,n) = 	2.25211597222159243612559019038215e+93  	2.36211624348137185095548918932957e+32
 cxroot(z,1,n) = 	1.12605798611079621806279509519108e+93  	-1.95038964421258820040188873700515e+93
 cxroot(z,2,n) = 	-1.12605798611079621806279509519107e+93  	-1.95038964421258820040188873700516e+93
 cxroot(z,3,n) = 	-2.25211597222159243612559019038215e+93  	-2.36211624348137185095548918932957e+32
 cxroot(z,4,n) = 	-1.12605798611079621806279509519109e+93  	1.95038964421258820040188873700515e+93
 cxroot(z,5,n) = 	1.12605798611079621806279509519106e+93  	1.95038964421258820040188873700516e+93
 cxroot(z,6,n) = 	2.25211597222159243612559019038215e+93  	2.36211624348137185095548918932957e+32
*string in : 	-6.742e-32 +5.418e-28i		 0
 z =  		-6.74199999999999999999999999999975e-32  	5.41799999999999999999999999999982e-28
 n = 0
 cxroot(z,0,n) = 	*** Bad exponent
*string in : 	-6.742e-32 +5.418e-28i		 5
 z =  		-6.74199999999999999999999999999975e-32  	5.41799999999999999999999999999982e-28
 n = 5
 cxroot(z,0,n) = 	3.34942775152176584202139994568678e-6  	1.08838720731327245352610153054949e-6
 cxroot(z,1,n) = 	-8.76491162776785704995176571612334e-11  	3.52182523246469013498790269802037e-6
 cxroot(z,2,n) = 	-3.34948192165470933904445421768916e-6  	1.08822048878690565788692285530684e-6
 cxroot(z,3,n) = 	-2.07000602316964513042325470318790e-6  	-2.84926798314035861081230620510253e-6
 cxroot(z,4,n) = 	2.07014784241886630601680849284742e-6  	-2.84916494542450963558862087877415e-6
 cxroot(z,5,n) = 	3.34942775152176584202139994568678e-6  	1.08838720731327245352610153054949e-6
*string in : 	-6.742e-32 +5.418e-28i		-7
 z =  		-6.74199999999999999999999999999975e-32  	5.41799999999999999999999999999982e-28
 n = -7
 cxroot(z,0,n) = 	7.65837448148998121618713939121830e+3  	-1.74811723348555378913979663122386e+3
 cxroot(z,1,n) = 	3.40818529984024800960469105139515e+3  	-7.07749154169038647804136418427133e+3
 cxroot(z,2,n) = 	-3.40843692689949209915851249187482e+3  	-7.07737036448524934618769616529362e+3
 cxroot(z,3,n) = 	-7.65843662824135791303191517134552e+3  	-1.74784495077717516639344701971059e+3
 cxroot(z,4,n) = 	-6.14147734488025099931700691441740e+3  	4.89784336040555173573173780583572e+3
 cxroot(z,5,n) = 	1.39642482780738226789679387973811e-1  	7.85535572340591727008564532544637e+3
 cxroot(z,6,n) = 	6.14165147620809104748881445563626e+3  	4.89762500662689577394492086921731e+3
 cxroot(z,7,n) = 	7.65837448148998121618713939121830e+3  	-1.74811723348555378913979663122386e+3
*string in : 	3.445      +9.751i		 0
 z =  		3.44500000000000000000000000000000e+0  	9.75099999999999999999999999999998e+0
 n = 0
 cxroot(z,0,n) = 	*** Bad exponent
*string in : 	3.445      +9.751i		 1
 z =  		3.44500000000000000000000000000000e+0  	9.75099999999999999999999999999998e+0
 n = 1
 cxroot(z,0,n) = 	3.44499999999999999999999999999999e+0  	9.75099999999999999999999999999993e+0
 cxroot(z,1,n) = 	3.44499999999999999999999999999999e+0  	9.75099999999999999999999999999993e+0
*string in : 	3.445      +9.751i		 8
 z =  		3.44500000000000000000000000000000e+0  	9.75099999999999999999999999999998e+0
 n = 8
 cxroot(z,0,n) = 	1.32330606577243352178426357125315e+0  	2.05277909425599257090031320533273e-1
 cxroot(z,1,n) = 	7.90565290910340081225382616536095e-1  	1.08087209447561835221428215760763e+0
 cxroot(z,2,n) = 	-2.05277909425599257090031320533273e-1  	1.32330606577243352178426357125315e+0
 cxroot(z,3,n) = 	-1.08087209447561835221428215760763e+0  	7.90565290910340081225382616536093e-1
 cxroot(z,4,n) = 	-1.32330606577243352178426357125315e+0  	-2.05277909425599257090031320533273e-1
 cxroot(z,5,n) = 	-7.90565290910340081225382616536095e-1  	-1.08087209447561835221428215760763e+0
 cxroot(z,6,n) = 	2.05277909425599257090031320533273e-1  	-1.32330606577243352178426357125315e+0
 cxroot(z,7,n) = 	1.08087209447561835221428215760763e+0  	-7.90565290910340081225382616536094e-1
 cxroot(z,8,n) = 	1.32330606577243352178426357125315e+0  	2.05277909425599257090031320533273e-1
*string in : 	3.445      +9.751i		-3
 z =  		3.44500000000000000000000000000000e+0  	9.75099999999999999999999999999998e+0
 n = -3
 cxroot(z,0,n) = 	4.20876809688621579087830495564152e-1  	-1.83124255393994750619270062039717e-1
 cxroot(z,1,n) = 	-3.69028662064619760319732778504017e-1  	-2.72927881357097467280775110994591e-1
 cxroot(z,2,n) = 	-5.18481476240018187680977170601378e-2  	4.56052136751092217900045173034306e-1
 cxroot(z,3,n) = 	4.20876809688621579087830495564152e-1  	-1.83124255393994750619270062039717e-1
*string in : 	-8.90      +0.532i		-2
 z =  		-8.89999999999999999999999999999998e+0  	5.31999999999999999999999999999998e-1
 n = -2
 cxroot(z,0,n) = 	9.99604982506209966058050470143605e-3  	-3.34752790604715930282072998043191e-1
 cxroot(z,1,n) = 	-9.99604982506209966058050470143605e-3  	3.34752790604715930282072998043191e-1
 cxroot(z,2,n) = 	9.99604982506209966058050470143605e-3  	-3.34752790604715930282072998043191e-1
*string in : 	-8.90      +0.532i		 4
 z =  		-8.89999999999999999999999999999998e+0  	5.31999999999999999999999999999998e-1
 n = 4
 cxroot(z,0,n) = 	1.23997414078689601534563605392407e+0  	1.20349999113483371578412940859485e+0
 cxroot(z,1,n) = 	-1.20349999113483371578412940859485e+0  	1.23997414078689601534563605392407e+0
 cxroot(z,2,n) = 	-1.23997414078689601534563605392407e+0  	-1.20349999113483371578412940859485e+0
 cxroot(z,3,n) = 	1.20349999113483371578412940859485e+0  	-1.23997414078689601534563605392407e+0
 cxroot(z,4,n) = 	1.23997414078689601534563605392407e+0  	1.20349999113483371578412940859485e+0
*string in : 	-7.772     +0.0i		 2
 z =  		-7.77200000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 n = 2
 cxroot(z,0,n) = 	0.00000000000000000000000000000000e+0  	2.78783069787245150781099035414601e+0
 cxroot(z,1,n) = 	-0.00000000000000000000000000000000e-4932  	-2.78783069787245150781099035414601e+0
 cxroot(z,2,n) = 	0.00000000000000000000000000000000e+0  	2.78783069787245150781099035414601e+0
*string in : 	-7.772     +0.0i		 3
 z =  		-7.77200000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 n = 3
 cxroot(z,0,n) = 	9.90408293311143478438598369923944e-1  	1.71543748425247955330834194622843e+0
 cxroot(z,1,n) = 	-1.98081658662228695687719673984788e+0  	8.66668474974256133875190074163217e-33
 cxroot(z,2,n) = 	9.90408293311143478438598369923926e-1  	-1.71543748425247955330834194622845e+0
 cxroot(z,3,n) = 	9.90408293311143478438598369923944e-1  	1.71543748425247955330834194622843e+0
*string in : 	-7.772     +0.0i		-5
 z =  		-7.77200000000000000000000000000000e+0  	0.00000000000000000000000000000000e+0
 n = -5
 cxroot(z,0,n) = 	5.36847686878643107257363336542852e-1  	-3.90042675578639771549141577230596e-1
 cxroot(z,1,n) = 	-2.05057569605880720989539695136260e-1  	-6.31102306149187710171421463979769e-1
 cxroot(z,2,n) = 	-6.63580234545524772535647282813180e-1  	-2.11852293882595943836157573684342e-33
 cxroot(z,3,n) = 	-2.05057569605880720989539695136267e-1  	6.31102306149187710171421463979766e-1
 cxroot(z,4,n) = 	5.36847686878643107257363336542849e-1  	3.90042675578639771549141577230600e-1
 cxroot(z,5,n) = 	5.36847686878643107257363336542852e-1  	-3.90042675578639771549141577230596e-1
*string in : 	+82.06126  +0i			-1
 z =  		8.20612599999999999999999999999998e+1  	0.00000000000000000000000000000000e+0
 n = -1
 cxroot(z,0,n) = 	1.21860181040359360799480778140624e-2  	0.00000000000000000000000000000000e+0
 cxroot(z,1,n) = 	1.21860181040359360799480778140624e-2  	0.00000000000000000000000000000000e+0
*string in : 	+82.06126  +0i			 7
 z =  		8.20612599999999999999999999999998e+1  	0.00000000000000000000000000000000e+0
 n = 7
 cxroot(z,0,n) = 	1.87693101837607556975192720672774e+0  	0.00000000000000000000000000000000e+0
 cxroot(z,1,n) = 	1.17024734874981030010757090663549e+0  	1.46744376058719606153264424800985e+0
 cxroot(z,2,n) = 	-4.17656443180620649389385361527841e-1  	1.82987243905469135385781001045461e+0
 cxroot(z,3,n) = 	-1.69105641475722743559414914847151e+0  	8.14369848318737859133482717352983e-1
 cxroot(z,4,n) = 	-1.69105641475722743559414914847152e+0  	-8.14369848318737859133482717352976e-1
 cxroot(z,5,n) = 	-4.17656443180620649389385361527851e-1  	-1.82987243905469135385781001045461e+0
 cxroot(z,6,n) = 	1.17024734874981030010757090663548e+0  	-1.46744376058719606153264424800985e+0
 cxroot(z,7,n) = 	1.87693101837607556975192720672774e+0  	0.00000000000000000000000000000000e+0
*string in : 	-88.7665   -7.432i		-4
 z =  		-8.87664999999999999999999999999998e+1  	-7.43200000000000000000000000000000e+0
 n = -4
 cxroot(z,0,n) = 	2.34923200046179826274744835500743e-1  	2.25310910766420749035113341230681e-1
 cxroot(z,1,n) = 	2.25310910766420749035113341230681e-1  	-2.34923200046179826274744835500743e-1
 cxroot(z,2,n) = 	-2.34923200046179826274744835500743e-1  	-2.25310910766420749035113341230681e-1
 cxroot(z,3,n) = 	-2.25310910766420749035113341230681e-1  	2.34923200046179826274744835500743e-1
 cxroot(z,4,n) = 	2.34923200046179826274744835500743e-1  	2.25310910766420749035113341230681e-1
*string in : 	-88.7665   -7.432i		 6
 z =  		-8.87664999999999999999999999999998e+1  	-7.43200000000000000000000000000000e+0
 n = 6
 cxroot(z,0,n) = 	1.84470339624198449322637011465834e+0  	-1.03106887436472288106679787880217e+0
 cxroot(z,1,n) = 	1.81528353637226802119923827722211e+0  	1.08202556641062850156122554046918e+0
 cxroot(z,2,n) = 	-2.94198598697164720271318374362265e-2  	2.11309444077535138262802341927136e+0
 cxroot(z,3,n) = 	-1.84470339624198449322637011465834e+0  	1.03106887436472288106679787880217e+0
 cxroot(z,4,n) = 	-1.81528353637226802119923827722212e+0  	-1.08202556641062850156122554046918e+0
 cxroot(z,5,n) = 	2.94198598697164720271318374362167e-2  	-2.11309444077535138262802341927136e+0
 cxroot(z,6,n) = 	1.84470339624198449322637011465834e+0  	-1.03106887436472288106679787880217e+0
*string in : 	+9.4332    -67.5584i		-1
 z =  		9.43319999999999999999999999999999e+0  	-6.75583999999999999999999999999998e+1
 n = -1
 cxroot(z,0,n) = 	2.02728375401364724578855508913375e-3  	1.45189380875159634153714031435497e-2
 cxroot(z,1,n) = 	2.02728375401364724578855508913375e-3  	1.45189380875159634153714031435497e-2
*string in : 	+9.4332    -67.5584i		 3
 z =  		9.43319999999999999999999999999999e+0  	-6.75583999999999999999999999999998e+1
 n = 3
 cxroot(z,0,n) = 	3.62917688255075002589288849092704e+0  	-1.87720161982097155538704358618249e+0
 cxroot(z,1,n) = 	-1.88884150485115835485810940216707e-1  	4.08156018502664933943396883584119e+0
 cxroot(z,2,n) = 	-3.44029273206563419040707755071033e+0  	-2.20435856520567778404692524965868e+0
 cxroot(z,3,n) = 	3.62917688255075002589288849092704e+0  	-1.87720161982097155538704358618249e+0
*string in : 	+9.4332    -67.5584i		-6
 z =  		9.43319999999999999999999999999999e+0  	-6.75583999999999999999999999999998e+1
 n = -6
 cxroot(z,0,n) = 	4.80690102311450939503450073059728e-1  	1.16959160946412676625038624489341e-1
 cxroot(z,1,n) = 	3.41634655740631655369657251049390e-1  	-3.57810259476251086455594871533628e-1
 cxroot(z,2,n) = 	-1.39055446570819284133792822010337e-1  	-4.74769420422663763080633496022970e-1
 cxroot(z,3,n) = 	-4.80690102311450939503450073059728e-1  	-1.16959160946412676625038624489341e-1
 cxroot(z,4,n) = 	-3.41634655740631655369657251049392e-1  	3.57810259476251086455594871533626e-1
 cxroot(z,5,n) = 	1.39055446570819284133792822010335e-1  	4.74769420422663763080633496022970e-1
 cxroot(z,6,n) = 	4.80690102311450939503450073059728e-1  	1.16959160946412676625038624489341e-1
*string in : 	8765.9431      +0i		 0
 z =  		8.76594309999999999999999999999996e+3  	0.00000000000000000000000000000000e+0
 n = 0
 cxroot(z,0,n) = 	*** Bad exponent
*string in : 	8765.9431      +0i		-2
 z =  		8.76594309999999999999999999999996e+3  	0.00000000000000000000000000000000e+0
 n = -2
 cxroot(z,0,n) = 	1.06807235994801408983052637399967e-2  	0.00000000000000000000000000000000e+0
 cxroot(z,1,n) = 	-1.06807235994801408983052637399967e-2  	0.00000000000000000000000000000000e+0
 cxroot(z,2,n) = 	1.06807235994801408983052637399967e-2  	0.00000000000000000000000000000000e+0
*string in : 	8765.9431      +0i		 5
 z =  		8.76594309999999999999999999999996e+3  	0.00000000000000000000000000000000e+0
 n = 5
 cxroot(z,0,n) = 	6.14553546775590737887926824134809e+0  	0.00000000000000000000000000000000e-4932
 cxroot(z,1,n) = 	1.89907489907056711732805091676940e+0  	5.84475155273224035605203777834818e+0
 cxroot(z,2,n) = 	-4.97184263294852080676768503744344e+0  	3.61225511538724788185504742800745e+0
 cxroot(z,3,n) = 	-4.97184263294852080676768503744346e+0  	-3.61225511538724788185504742800740e+0
 cxroot(z,4,n) = 	1.89907489907056711732805091676936e+0  	-5.84475155273224035605203777834820e+0
 cxroot(z,5,n) = 	6.14553546775590737887926824134809e+0  	0.00000000000000000000000000000000e-4932
*string in : 	8999.432192e+8 +3.042e+12i	 1
 z =  		8.99943219199999999999999999999988e+11  	3.04199999999999999999999999999996e+12
 n = 1
 cxroot(z,0,n) = 	8.99943219199999999999999999999967e+11  	3.04199999999999999999999999999988e+12
 cxroot(z,1,n) = 	8.99943219199999999999999999999967e+11  	3.04199999999999999999999999999988e+12
*string in : 	8999.432192e+8 +3.042e+12i	-4
 z =  		8.99943219199999999999999999999988e+11  	3.04199999999999999999999999999996e+12
 n = -4
 cxroot(z,0,n) = 	7.11075221898720250274919221558507e-4  	-2.36266600753309815771769862449531e-4
 cxroot(z,1,n) = 	-2.36266600753309815771769862449531e-4  	-7.11075221898720250274919221558507e-4
 cxroot(z,2,n) = 	-7.11075221898720250274919221558507e-4  	2.36266600753309815771769862449531e-4
 cxroot(z,3,n) = 	2.36266600753309815771769862449531e-4  	7.11075221898720250274919221558507e-4
 cxroot(z,4,n) = 	7.11075221898720250274919221558507e-4  	-2.36266600753309815771769862449531e-4
*string in : 	8999.432192e+8 +3.042e+12i	 6
 z =  		8.99943219199999999999999999999988e+11  	3.04199999999999999999999999999996e+12
 n = 6
 cxroot(z,0,n) = 	1.18455403945577457007986107303075e+2  	2.57263015548054585578986556269696e+1
 cxroot(z,1,n) = 	3.69480712809080994919020102792840e+1  	1.15448539809820233324924645366636e+2
 cxroot(z,2,n) = 	-8.15073326646693575160840970237913e+1  	8.97222382550147747670259897396666e+1
 cxroot(z,3,n) = 	-1.18455403945577457007986107303075e+2  	-2.57263015548054585578986556269696e+1
 cxroot(z,4,n) = 	-3.69480712809080994919020102792845e+1  	-1.15448539809820233324924645366636e+2
 cxroot(z,5,n) = 	8.15073326646693575160840970237908e+1  	-8.97222382550147747670259897396668e+1
 cxroot(z,6,n) = 	1.18455403945577457007986107303075e+2  	2.57263015548054585578986556269696e+1
*string in : 	0  +6.7891e+24i			-1
 z =  		0.00000000000000000000000000000000e+0  	6.78909999999999999999999999999981e+24
 n = -1
 cxroot(z,0,n) = 	0.00000000000000000000000000000000e+0  	-1.47294928635607076048371654563939e-25
 cxroot(z,1,n) = 	0.00000000000000000000000000000000e+0  	-1.47294928635607076048371654563939e-25
*string in : 	0  +6.7891e+24i		 	 4
 z =  		0.00000000000000000000000000000000e+0  	6.78909999999999999999999999999981e+24
 n = 4
 cxroot(z,0,n) = 	1.49131160464594966765664431872971e+6  	6.17721492368735536626680148215766e+5
 cxroot(z,1,n) = 	-6.17721492368735536626680148215766e+5  	1.49131160464594966765664431872971e+6
 cxroot(z,2,n) = 	-1.49131160464594966765664431872971e+6  	-6.17721492368735536626680148215766e+5
 cxroot(z,3,n) = 	6.17721492368735536626680148215766e+5  	-1.49131160464594966765664431872971e+6
 cxroot(z,4,n) = 	1.49131160464594966765664431872971e+6  	6.17721492368735536626680148215766e+5
*string in : 	0  +6.7891e+24i			-5
 z =  		0.00000000000000000000000000000000e+0  	6.78909999999999999999999999999981e+24
 n = -5
 cxroot(z,0,n) = 	1.02764682411232921244078412890458e-5  	-3.33902693925288923947930567070142e-6
 cxroot(z,1,n) = 	2.13058351086539610819333497371532e-38  	-1.08053181541254104328781191179991e-5
 cxroot(z,2,n) = 	-1.02764682411232921244078412890458e-5  	-3.33902693925288923947930567070146e-6
 cxroot(z,3,n) = 	-6.35120665732304442309317889314292e-6  	8.74168601631559445591836522970093e-6
 cxroot(z,4,n) = 	6.35120665732304442309317889314281e-6  	8.74168601631559445591836522970102e-6
 cxroot(z,5,n) = 	1.02764682411232921244078412890458e-5  	-3.33902693925288923947930567070142e-6
*string in : 	-6.5571e+101	+5.667e+101i	 2
 z =  		-6.55709999999999999999999999999921e+101  	5.66699999999999999999999999999932e+101
 n = 2
 cxroot(z,0,n) = 	3.24771341986826685821628793332171e+50  	8.72459984512713530875648666504291e+50
 cxroot(z,1,n) = 	-3.24771341986826685821628793332171e+50  	-8.72459984512713530875648666504291e+50
 cxroot(z,2,n) = 	3.24771341986826685821628793332171e+50  	8.72459984512713530875648666504291e+50
*string in : 	-6.5571e+101	+5.667e+101i	-6
 z =  		-6.55709999999999999999999999999921e+101  	5.66699999999999999999999999999932e+101
 n = -6
 cxroot(z,0,n) = 	9.41362522394899648838528188593018e-18  	-4.03353923660788104872986481245976e-18
 cxroot(z,1,n) = 	1.21366516591078164555722991268586e-18  	-1.01692082039497468914797822534830e-17
 cxroot(z,2,n) = 	-8.19996005803821484282805197324433e-18  	-6.13566896734186584274991744102328e-18
 cxroot(z,3,n) = 	-9.41362522394899648838528188593018e-18  	4.03353923660788104872986481245976e-18
 cxroot(z,4,n) = 	-1.21366516591078164555722991268590e-18  	1.01692082039497468914797822534830e-17
 cxroot(z,5,n) = 	8.19996005803821484282805197324429e-18  	6.13566896734186584274991744102331e-18
 cxroot(z,6,n) = 	9.41362522394899648838528188593018e-18  	-4.03353923660788104872986481245976e-18
*string in : 	-6.5571e+101	+5.667e+101i	 7
 z =  		-6.55709999999999999999999999999921e+101  	5.66699999999999999999999999999932e+101
 n = 7
 cxroot(z,0,n) = 	3.43450382175160666738379853126571e+14  	1.24196227875954786406563854783257e+14
 cxroot(z,1,n) = 	1.17037289773502250896846921925123e+14  	3.45955402960198432037890924481401e+14
 cxroot(z,2,n) = 	-1.97507268953232469668370261134849e+14  	3.07203103411270085393493269638217e+14
 cxroot(z,3,n) = 	-3.63324825744123261282510350975140e+14  	3.71206011923631925217895900528064e+13
 cxroot(z,4,n) = 	-2.55551378273892129201902811708806e+14  	-2.60914470846662896308965209747485e+14
 cxroot(z,5,n) = 	4.46574693346927324280481718746638e+13  	-3.62475624652887503419746874674175e+14
 cxroot(z,6,n) = 	3.11238331687892210089508476892435e+14  	-1.91085239940236096631025554534022e+14
 cxroot(z,7,n) = 	3.43450382175160666738379853126571e+14  	1.24196227875954786406563854783257e+14
*string in : 	0		-8.88165e+152i	+8
 z =  		0.00000000000000000000000000000000e+0  	-8.88164999999999999999999999999840e+152
 n = 8
 cxroot(z,0,n) = 	1.28865198244901803327118277330668e+19  	-2.56328816557423677082928985114710e+18
 cxroot(z,1,n) = 	1.09246639978046533937412053957046e+19  	7.29962710977911611140762666656649e+18
 cxroot(z,2,n) = 	2.56328816557423677082928985114710e+18  	1.28865198244901803327118277330668e+19
 cxroot(z,3,n) = 	-7.29962710977911611140762666656651e+18  	1.09246639978046533937412053957046e+19
 cxroot(z,4,n) = 	-1.28865198244901803327118277330668e+19  	2.56328816557423677082928985114710e+18
 cxroot(z,5,n) = 	-1.09246639978046533937412053957046e+19  	-7.29962710977911611140762666656649e+18
 cxroot(z,6,n) = 	-2.56328816557423677082928985114710e+18  	-1.28865198244901803327118277330668e+19
 cxroot(z,7,n) = 	7.29962710977911611140762666656650e+18  	-1.09246639978046533937412053957046e+19
 cxroot(z,8,n) = 	1.28865198244901803327118277330668e+19  	-2.56328816557423677082928985114710e+18
*string in : 	0		-8.88165e+152i	-9
 z =  		0.00000000000000000000000000000000e+0  	-8.88164999999999999999999999999840e+152
 n = -9
 cxroot(z,0,n) = 	9.97870965088569815908905826652984e-18  	1.75951574410709574967418295743179e-18
 cxroot(z,1,n) = 	8.77512999691913904154353763861475e-18  	-5.06632366589522483121651975451829e-18
 cxroot(z,2,n) = 	3.46556949268742445850652210691339e-18  	-9.52157392670950942498743281615575e-18
 cxroot(z,3,n) = 	-3.46556949268742445850652210691336e-18  	-9.52157392670950942498743281615576e-18
 cxroot(z,4,n) = 	-8.77512999691913904154353763861474e-18  	-5.06632366589522483121651975451831e-18
 cxroot(z,5,n) = 	-9.97870965088569815908905826652985e-18  	1.75951574410709574967418295743176e-18
 cxroot(z,6,n) = 	-6.51314015819827370058253615961652e-18  	7.76205818260241367531324985872392e-18
 cxroot(z,7,n) = 	-4.20960441839520814267134493576358e-50  	1.01326473317904496624330395090366e-17
 cxroot(z,8,n) = 	6.51314015819827370058253615961644e-18  	7.76205818260241367531324985872399e-18
 cxroot(z,9,n) = 	9.97870965088569815908905826652984e-18  	1.75951574410709574967418295743179e-18
*string in : 	-544.678e+503	-897.654e+502i	 3
 z =  		-5.44677999999999999999999999999674e+505  	-8.97653999999999999999999999999465e+504
 n = 3
 cxroot(z,0,n) = 	2.08043099784152816080724109600463e+168  	-3.18900248054478334106087660928582e+168
 cxroot(z,1,n) = 	1.72154166196260836245101783749351e+168  	3.39620733522376370276148871136721e+168
 cxroot(z,2,n) = 	-3.80197265980413652325825893349813e+168  	-2.07204854678980361700612102081366e+167
 cxroot(z,3,n) = 	2.08043099784152816080724109600463e+168  	-3.18900248054478334106087660928582e+168
*string in : 	-544.678e+503	-897.654e+502i	-5
 z =  		-5.44677999999999999999999999999674e+505  	-8.97653999999999999999999999999465e+504
 n = -5
 cxroot(z,0,n) = 	5.88199772525492267580530626031640e-102  	3.98665087599364711184488558026957e-102
 cxroot(z,1,n) = 	5.60916755178609429179499109477798e-102  	-4.36216939411515654134249509620456e-102
 cxroot(z,2,n) = 	-2.41534152965808044790248509528062e-102  	-6.68261982624134939597775453482225e-102
 cxroot(z,3,n) = 	-7.10193071155395019718217100024104e-102  	2.32083207604086143436753149631841e-103
 cxroot(z,4,n) = 	-1.97389303582898632251564125957274e-102  	6.82605513675877268203861090112534e-102
 cxroot(z,5,n) = 	5.88199772525492267580530626031640e-102  	3.98665087599364711184488558026957e-102
*string in : 	-544.678e+503	-897.654e+502i	13
 z =  		-5.44677999999999999999999999999674e+505  	-8.97653999999999999999999999999465e+504
 n = 13
 cxroot(z,0,n) = 	7.79344490007086455584559566269104e+38  	-1.81735871322975882363528639936242e+38
 cxroot(z,1,n) = 	7.74532145331754031294116644489207e+38  	2.01260321170660909453409994796695e+38
 cxroot(z,2,n) = 	5.92283820285132130117567844798418e+38  	5.38150199533899860260058426271401e+38
 cxroot(z,3,n) = 	2.74350409804992198957107933847932e+38  	7.51756352596876808207053692969068e+38
 cxroot(z,4,n) = 	-1.06433373280616489570539335196878e+38  	7.93144184926067449403855644833413e+38
 cxroot(z,5,n) = 	-4.62834553208830637128189980977077e+38  	6.52832242912303657994089006775061e+38
 cxroot(z,6,n) = 	-7.13205914757924072770223848811328e+38  	3.62964301528731154663264482330851e+38
 cxroot(z,7,n) = 	-8.00190396298996258994787677673546e+38  	-1.00543871410564877562302637131536e+37
 cxroot(z,8,n) = 	-7.03860901387628376122461698217384e+38  	-3.80769736885328388916953284169125e+38
 cxroot(z,9,n) = 	-4.46285356411754365449926444120838e+38  	-6.64255328681946144769646225670306e+38
 cxroot(z,10,n) = 	-8.64712146035282137000848264263913e+37  	-7.95568029822036964505865226975347e+38
 cxroot(z,11,n) = 	2.93152440379262573114371746803180e+38  	-7.44625682964004291102652029297394e+38
 cxroot(z,12,n) = 	6.05618404141051024668490075215587e+38  	-5.23098565851191680566855578214917e+38
 cxroot(z,13,n) = 	7.79344490007086455584559566269104e+38  	-1.81735871322975882363528639936242e+38
*string in : 	6557.821e+2456  -76.671e+2511i	-2
 z =  		6.55782099999999999999999999998092e+2459  	-7.66709999999999999999999999997722e+2512
 n = -2
 cxroot(z,0,n) = 	2.55369742358620933665735778340361e-1257  	2.55369742358620933665735778340361e-1257
 cxroot(z,1,n) = 	-2.55369742358620933665735778340361e-1257  	-2.55369742358620933665735778340361e-1257
 cxroot(z,2,n) = 	2.55369742358620933665735778340361e-1257  	2.55369742358620933665735778340361e-1257
*string in : 	6557.821e+2456  -76.671e+2511i -17
 z =  		6.55782099999999999999999999998092e+2459  	-7.66709999999999999999999999997722e+2512
 n = -17
 cxroot(z,0,n) = 	1.51844968579084304297720606731527e-148  	1.40705084520443954877026773601041e-149
 cxroot(z,1,n) = 	1.46674070292090034126663085756674e-148  	-4.17323710665136316273288184977301e-149
 cxroot(z,2,n) = 	1.21694026063068469489774227468009e-148  	-9.18990626254879951312309628716174e-149
 cxroot(z,3,n) = 	8.02785292843524381637810193591787e-149  	-1.29654276546604973253080073223315e-148
 cxroot(z,4,n) = 	2.80209722870974947799984322274845e-149  	-1.49898961980955247071034398639708e-148
 cxroot(z,5,n) = 	-2.80209722870974947799984322274843e-149  	-1.49898961980955247071034398639708e-148
 cxroot(z,6,n) = 	-8.02785292843524381637810193591783e-149  	-1.29654276546604973253080073223315e-148
 cxroot(z,7,n) = 	-1.21694026063068469489774227468009e-148  	-9.18990626254879951312309628716175e-149
 cxroot(z,8,n) = 	-1.46674070292090034126663085756674e-148  	-4.17323710665136316273288184977303e-149
 cxroot(z,9,n) = 	-1.51844968579084304297720606731527e-148  	1.40705084520443954877026773601039e-149
 cxroot(z,10,n) = 	-1.36508362457456162768506813867495e-148  	6.79730878367749692938386117542187e-149
 cxroot(z,11,n) = 	-1.02735545566999724700238541489736e-148  	1.12695525057266917333078255839988e-148
 cxroot(z,12,n) = 	-5.50877239704098698707331320984911e-149  	1.42197807151313280225871635051500e-148
 cxroot(z,13,n) = 	-6.58962463114069875944736337616700e-181  	1.52495487444324569484366146453116e-148
 cxroot(z,14,n) = 	5.50877239704098698707331320984899e-149  	1.42197807151313280225871635051501e-148
 cxroot(z,15,n) = 	1.02735545566999724700238541489735e-148  	1.12695525057266917333078255839989e-148
 cxroot(z,16,n) = 	1.36508362457456162768506813867495e-148  	6.79730878367749692938386117542194e-149
 cxroot(z,17,n) = 	1.51844968579084304297720606731527e-148  	1.40705084520443954877026773601041e-149
*/
