/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include "xpre.h"

static struct xpr ctan(struct xpr u);
static struct xpr rred(struct xpr u,int i,int *p);

/* Added by Ivano Primi - 01/30/2005 */

static int xodd (struct xpr x)
{
  unsigned short* p = (unsigned short*) &x;
  short e, i;

  e = (*p & m_exp) - bias; /* exponent of x */
  if (e < 0)
    return 0;
  else
    {
      for (i=1; e / 16 > 0; i++, e -= 16);
      /* Now e = 0, ..., 15 */
      return ( i <= XDIM ? p[i] & 0x8000 >> e : 0 );  
    }
}

struct xpr xtan(struct xpr z)
{ 
  int k,m;
  
  z=rred(z,'t',&k);
  if ( (xsigerr(xprcmp(&z, &pi2) >= 0, XEDOM, "xtan()")) )
    return x_huge;
  else
    {
      if(xprcmp(&z,&pi4)==1)
	{ 
	  m=1; 
	  z=xadd(pi2,z,1);
	} 
      else 
	m=0;
      if((k)) 
	z=xneg(ctan(z)); 
      else 
	z=ctan(z);
      if(m) 
	return xdiv(one,z); 
      else 
	return z;
    }
}

struct xpr xcos(struct xpr z)
{ 
  int k;
  
  z=rred(z,'c',&k);
  if(xex(&z)<k_lin)
    {
      if((k)) 
	return xneg(one); 
      else 
	return one;
    }
  z=ctan(xpr2(z,-1)); 
  z=xmul(z,z);
  z=xdiv(xadd(one,z,1),xadd(one,z,0));
  if((k)) 
    return xneg(z); 
  else 
    return z;
}

struct xpr xsin(struct xpr z)
{ 
  int k;
  
  z=rred(z,'s',&k); 
  if(xex(&z) >= k_lin)
    {
      z=ctan(xpr2(z,-1)); 
      z=xdiv(xpr2(z,1),xadd(one,xmul(z,z),0));
    }
  if((k)) 
    return xneg(z); 
  else 
    return z;
}

static struct xpr ctan(struct xpr z)
{ 
  struct xpr s,f,d; int m;
  unsigned short k;
  
  if(xex(&z)<k_lin) 
    return z;
  s=xneg(xmul(z,z));
  for (k=1; k<=XDIM && s.nmm[k] == 0; k++);
  if ( (xsigerr (s.nmm[0] == 0xffff && k > XDIM, XFPOFLOW, NULL)) )
    return zero;
  else
    {
      f=zero;
      for(d=inttox(m=ms_trg); m>1 ;)
	{
	  f=xdiv(s,xadd(d,f,0)); 
	  d=inttox(m-=2); 
	}
      return xdiv(z,xadd(d,f,0));
    }
}

static struct xpr rred(struct xpr z,int kf,int *ps)
{ 
  struct xpr is, q;
  
  if(neg(&z))
    { 
      z=xneg(z); 
      is=one;
    } 
  else 
    is=zero;
  z=xfmod(z,pi,&q);
  if(kf=='t') 
    q = is; 
  else if (kf=='s') 
    q = xadd (q, is, 0);
  if(xprcmp(&z,&pi2)==1) 
    {
      z=xadd(pi,z,1);
      if(kf=='c' || kf=='t') 
	q = xadd (q, one, 0);
    }
  *ps = (xodd(q)) ? 1 : 0;
  return z;
}
