/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include "xpre.h"

/*

  Modified by Ivano Primi - 11/21/2004 and 03/05/2005

*/

int xprcmp(const struct xpr *pa, const struct xpr *pb)
{ 
  unsigned short e, k, *p, *q, p0, q0; 
  int m;
  
  p=(unsigned short *)pa; 
  q=(unsigned short *)pb; 
  for (m=1; m <= XDIM && p[m] == 0; m++);
  if ( m > XDIM && (*p & m_exp) < m_exp )
    /* *pa is actually zero */
    p0 = 0;
  else
    p0 = *p;
  for (m=1; m <= XDIM && q[m] == 0; m++);
  if ( m > XDIM && (*q & m_exp) < m_exp )
    /* *pb is actually zero */
    q0 = 0;
  else
    q0 = *q;
  e= p0 & m_sgn; k= q0 & m_sgn;
  if(e && !k) 
    return -1; 
  else if(!e && k) 
    return 1;
  else /* *pa and *pb have the same sign */
    {
      m = (e) ? -1 : 1; 
      e= p0 & m_exp; k= q0 & m_exp;
      if(e>k) 
	return m; 
      else if(e<k) 
	return -m;
      else
	{
	  for(e=0; *++p== *++q && e<XDIM ;++e);
	  if(e<XDIM)
	    return (*p> *q ? m : -m);
	  else
	    return 0;
	}
    }
}
