/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include <stdio.h>
#include "xpre.h"

struct xpr xlog(struct xpr z)
{ 
  struct xpr f,h; int k,m;
  
  if( (xsigerr ((neg(&z)) || xex(&z)== -bias, XEDOM, "xlog()")) ) 
    return x_huge;
  else if(xprcmp(&z,&one)==0) 
    return zero;
  else
    {
      z=xfrex(z,&m); z=xmul(z,srt2);
      z=xdiv(xadd(z,one,1),xadd(z,one,0));
      h=xpr2(z,1); z=xmul(z,z);
      for(f=h,k=1; xex(&h)> -max_p ;){
	h=xmul(h,z); 
	f=xadd(f,xdiv(h,inttox(k+=2)),0);
      }
      return xadd(f,xmul(ln2,dbltox(m-.5)),0);
    }
}

struct xpr xlog2(struct xpr z)
{ 
  struct xpr f,h; int k,m;
  
  if( (xsigerr ((neg(&z)) || xex(&z)== -bias, XEDOM, "xlog2()")) ) 
    return x_huge;
  else if(xprcmp(&z,&one)==0) 
    return zero;
  else
    {
      z=xfrex(z,&m); z=xmul(z,srt2);
      z=xdiv(xadd(z,one,1),xadd(z,one,0));
      h=xpr2(z,1); z=xmul(z,z);
      for(f=h,k=1; xex(&h)> -max_p ;){
	h=xmul(h,z); 
	f=xadd(f,xdiv(h,inttox(k+=2)),0);
      }
      return xadd(xmul(f,log2_e),dbltox(m-.5),0);
    }
}

struct xpr xlog10(struct xpr z)
{
  return xmul(xlog(z), log10_e);  
}
