/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include "xpre.h"

struct xpr xatanh(struct xpr x)
{
  struct xpr y = x;

  y.nmm[0] &= m_exp; /* Now y == abs(x) */
  if ( (xsigerr (xprcmp(&y, &one) >= 0, XEDOM, "xatanh")) )
    return x_huge;
  else
    {
      y = xdiv (xadd (one, x, 0), xadd (one, x, 1));
      return xpr2 (xlog (y), -1);
    }
}

struct xpr xasinh(struct xpr x)
{
  struct xpr y = xmul (x, x);
 
  y = xsqrt (xadd (one, y, 0));
  if ( (x.nmm[0] & m_sgn) )
    return xneg( xlog (xadd (y, x, 1)) );
  else
    return xlog (xadd (x, y, 0));
}

struct xpr xacosh(struct xpr x)
{ 
  if ( (xsigerr(xprcmp(&x, &one) < 0, XEDOM, "xacosh()")) )
    return zero;
  else
    {
      struct xpr y = xmul (x, x);
      
      y = xsqrt (xadd (y, one, 1));
      return xlog (xadd (x, y, 0));
    }
} 
