/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include "xpre.h"

struct xpr xexp2(struct xpr x)
{
  struct xpr s, d, f;
  unsigned short* pf = (unsigned short*) &x;
  int m, k;

  if ( xprcmp (&x, &xE2min) < 0 )
    return zero;
  else if ( (xsigerr (xprcmp (&x, &xE2max) > 0, XFPOFLOW, NULL)) )
    return x_huge;
  else
    {
      m = (*pf & m_sgn) ? 1 : 0;
      x = sfmod (x, &k);  
      if ((m))
	k *= -1;
      /* -bias <= k <= +bias */
      x = xmul (x, ln2);
      if(xex(&x)> -bias)
	{
	  x=xpr2(x,-1); 
	  s=xmul(x,x); 
	  f=zero;
	  for(d=inttox(m=ms_exp); m>1 ; m-=2, d=inttox(m))
	    f=xdiv(s,xadd(d,f,0)); 
	  f=xdiv(x,xadd(d,f,0));
	  f=xdiv(xadd(d,f,0),xadd(d,f,1));
	}
      else 
	f=one;      
      pf = (unsigned short*) &f;
      if (-k > *pf)
	return zero;
      else
	{
	  *pf += k;
	  if ( (xsigerr(*pf >= m_exp, XFPOFLOW, NULL)) )
	    return x_huge;
	  else
	    return f;
	}
    }
}

struct xpr xexp(struct xpr z)
{ 
  return xexp2 ( xmul (z, log2_e) );
}

struct xpr xexp10(struct xpr z)
{ 
  return xexp2 ( xmul (z, log2_10) );
}


