/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include "xpre.h"

struct xpr sfmod(struct xpr s,int *p)
{ 
  unsigned short *pa,*pb; short e,k;
  
  pa=(unsigned short *)&s; pb=pa+1;
  e=(*pa&m_exp)-bias;
  if( (xsigerr (e>=15, XFPOFLOW, NULL)) )
    { 
      *p= -1; 
      return s;
    } 
  else if(e<0)
    { 
      *p=0; 
      return s;
    }
  *p= *pb>>(15-e); 
  lshift(++e,pb,XDIM); 
  *pa-=e;
  for(e=0; *pb==0 && e<max_p ;++pb,e+=16);
  if(e==max_p) 
    return zero;
  for(k=0; !((*pb<<k)&m_sgn) ;++k);
  if((k+=e)) { 
    lshift(k,pa+1,XDIM); 
    *pa-=k;
  }
  return s;
}
