/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include <stdlib.h> /* for calloc() */
#include "xpre.h"   /* Automatically includes <stdio.h> */

static double ltn2=.3010299956639812;
static int q[5*XDIM+4];

/* Source code added by Ivano Primi - 11/28/2004 */

/* See print.c for all these functions */
extern void xfileputc (int c, FILE* stream);
extern void xprintfmt (FILE* stream, const char* fmt, ...);
extern void xsprintfmt (char* buffer, const char* fmt, ...);

/* sc_not != 0 tells using scientific notation                     */
/* sign   != 0 tells putting a '+' sign before non negative values */

void print_xpr (FILE* stream, struct xpr u, 
		int sc_not, int sign, int lim)
{
  int *p=q, k, m;
  unsigned short *pa=(unsigned short *)&u;
  
  if ( lim < 0 )
    lim = 0;
  if ( lim >= 5*XDIM+2 )
    lim = 5*XDIM+2;
  if((*pa&m_sgn))
    { 
      *pa^=m_sgn; 
      xprintfmt (stream, " -");
    } 
  else
    {
      if ((sign))
	xprintfmt (stream, " +");
      else
	xprintfmt (stream, "  ");
    }
  if(*pa==0)
    { 
      xprintfmt (stream, "0."); 
      for(k=0; k<lim ;++k) 
	xprintfmt (stream, "0");
      if ( (sc_not) )
	xprintfmt (stream, "e+0\n");
      else
	xprintfmt (stream, "\n");
    }
  else
    { 
      *p=0; m=((*pa&m_exp)-bias); 
      m=(int)((double)(m+1)*ltn2);
      if(m) u=xmul(u,xpwr(ten,-m));
      while((*pa&m_exp)<bias)
	{ 
	  --m; 
	  u=xmul(u,ten);
	}
      for(k=0; k<=lim ;++k)
	{
	  u=sfmod(u,++p); 
	  if(*pa==0) break; 
	  u=xmul(ten,u); 
	}
      for(; k<=lim ;++k) 
	*++p=0;
      if(*pa)
	{ 
	  u=sfmod(u,&k); 
	  if(k>=5) ++(*p);
	  while(*p==10)
	    { 
	      *p=0; 
	      ++(*--p);
	    } 
	}
      p=q; 
      if (*p==0)  
	++p;
      else
	++m;
      /* Now has come the moment to print */
      if ( (sc_not) )
	{
	  xprintfmt (stream, "%d.",*p++);
	  for(k=0; k<lim ;++k) 
	    xprintfmt (stream, "%d",*p++);
	  if(m>=0) 
	    xprintfmt (stream, "e+%d\n",m); 
	  else 
	    xprintfmt (stream, "e%d\n",m);
	}
      else
	{
	  if ( m >= 0 )
	    {
	      for (k = 0; k <= m; k++)
		{
		  if ( k <= lim )
		    xprintfmt (stream, "%d", p[k]);
		  else
		    xprintfmt (stream, "0");
		}
	      if ( k <= lim )
		{
		  xprintfmt (stream, ".");
		  for (; k<= lim; k++)
		    xprintfmt (stream, "%d", p[k]);
		}
	      xprintfmt (stream, "\n");
	    }
	  else
	    {
	      xprintfmt (stream, "0.");
	      for (k=1; k< -m; k++)
		xprintfmt (stream, "0");
	      for(k=0; k <= lim ;++k) 
		xprintfmt (stream, "%d",*p++);
	      xprintfmt (stream, "\n");
	    }
	}
    } /* End of *pa != 0 */
}

#define BUFF_SIZE 5120 /* 5 Kb */

char* asprint_xpr (struct xpr u, int sc_not, int sign, int lim)
{
  int *p=q, k, m;
  unsigned short *pa=(unsigned short *)&u;
  char *buffer, *ptr;

  if ( lim < 0 )
    lim = 0;
  if ( lim > 5*XDIM+2 )
    lim = 5*XDIM+2;
  if ( !(buffer = (char*)calloc (BUFF_SIZE, sizeof(char))) )
    return NULL;
  else
    {
      if((*pa&m_sgn))
	{ 
	  *pa^=m_sgn; 
	  xsprintfmt (buffer, "-");
	} 
      else
	{
	  if ((sign))
	    xsprintfmt (buffer, "+");
	}
      if(*pa==0)
	{ 
	  xsprintfmt (buffer, "0."); 
	  for(k=0; k<lim ;++k) 
	    xsprintfmt (buffer, "0");
	  if ( (sc_not) )
	    xsprintfmt (buffer, "e+0"); 
	}
      else
	{ 
	  *p=0; m=((*pa&m_exp)-bias); 
	  m=(int)((double)(m+1)*ltn2);
	  if(m) u=xmul(u,xpwr(ten,-m));
	  while((*pa&m_exp)<bias)
	    { 
	      --m; 
	      u=xmul(u,ten);
	    }
	  for(k=0; k<=lim ;++k)
	    {
	      u=sfmod(u,++p); 
	      if(*pa==0) break; 
	      u=xmul(ten,u); 
	    }
	  for(; k<=lim ;++k) 
	    *++p=0;
	  if(*pa)
	    { 
	      u=sfmod(u,&k); 
	      if(k>=5) ++(*p);
	      while(*p==10)
		{ 
		  *p=0; 
		  ++(*--p);
		} 
	    }
	  p=q; 
	  if (*p==0)  
	    ++p;
	  else
	    ++m;
	  /* Now has come the moment to print */
	  if ( (sc_not) )
	    {
	      xsprintfmt (buffer, "%d.",*p++);
	      for(k=0; k<lim ;++k) 
		xsprintfmt (buffer, "%d",*p++);
	      if(m>=0) 
		xsprintfmt (buffer, "e+%d",m); 
	      else 
		xsprintfmt (buffer, "e%d",m);
	    }
	  else
	    {
	      if ( m >= 0 )
		{
		  for (k = 0; k <= m; k++)
		    {
		      if ( k <= lim )
			xsprintfmt (buffer, "%d", p[k]);
		      else
			xsprintfmt (buffer, "0");
		    }
		  if ( k <= lim )
		    {
		      xsprintfmt (buffer, ".");
		      for (; k<= lim; k++)
			xsprintfmt (buffer, "%d", p[k]);
		    }
		}
	      else
		{
		  xsprintfmt (buffer, "0.");
		  for (k=1; k < -m; k++)
		    xsprintfmt (buffer, "0");
		  for(k=0; k <= lim ;++k) 
		    xsprintfmt (buffer, "%d",*p++);
		}
	    }
	} /* End of *pa != 0 */
      for (k=0; buffer[k] != '\0'; k++);
      /* Now k is the length of the buffer. */
      /* We shrink the buffer so that it has the exact */
      /* size to contain all its non null chars.       */
      ptr = (char*) realloc (buffer, k+1);
      return (ptr != NULL) ? ptr : buffer;
    } /* End of buffer != 0 */
}

char* xtoa (struct xpr u,int lim)
{
  return asprint_xpr (u, 1, 0, lim);
}

void bxprint (FILE* stream, struct xpr u)
{
  int i;
  unsigned short n;

  for (n = 0x8000; n != 0x0; n >>= 1)
    {
      if ( (n & u.nmm[0]) )
	xfileputc ('1', stream);
      else
	xfileputc ('0', stream);
    }
  xfileputc ('.', stream);
  for(i=0; i<XDIM ;++i)
    {
      for (n = 0x8000; n != 0x0; n >>= 1)
	{
	  if ( (n & u.nmm[i+1]) )
	    xfileputc ('1', stream);
	  else
	    xfileputc ('0', stream);
	}
      xfileputc (' ', stream);
    }
}

/* End Additions 11/28/2004 */

void prxpr(struct xpr u,int lim)
{
  /* Modified by Ivano Primi - 11/29/2004 */ 
  print_xpr (stdout, u, 1, 0, lim);
}

void xprint(FILE* stream, struct xpr u)
{ 
  int i;
  
  /* Modified by Ivano Primi - 4/2/2005 */ 
  fprintf(stream, "%04x.",u.nmm[0]);
  for(i=0; i<XDIM ;++i) 
    fprintf(stream, "%04x",u.nmm[i+1]);
  fprintf(stream, "\n");
}

/* 
   Special output functions. 
   Added by Ivano Primi, 01/06/2005 
*/

/* See print.c for the next three functions */

extern int xwprint (const char* buff, short mfwd, char padding, FILE* fp);
extern void xwsprint (char* dest, const char* src, short mfwd, char padding);
extern unsigned short xwsnprint (char* dest, size_t dsize, const char* src, 
				 short mfwd, char padding);

int xfout (FILE * fp, struct xoutflags ofs, struct xpr x)
{
  char* str;
  int errcode;

  ofs.notat = (ofs.notat <= 0) ? XOUT_FIXED : XOUT_SCIENTIFIC;
  ofs.sf = (ofs.sf <= 0) ? 0 : 1;
  if ( ofs.lim < 0 )
    ofs.lim = XDEF_LIM;
  if ( ofs.padding < 0 )
    ofs.padding = ' '; /* blank */
  str = asprint_xpr (x, ofs.notat, ofs.sf, ofs.lim);
  errcode = xwprint (str, ofs.mfwd, ofs.padding, fp);
  if ((str))
    free ((void*)str);
  return errcode;
}

/* Exactly the same as xfout(), but it prints on stdout */

int xout  (struct xoutflags ofs, struct xpr x)
{
  char* str;
  int errcode;

  ofs.notat = (ofs.notat <= 0) ? XOUT_FIXED : XOUT_SCIENTIFIC;
  ofs.sf = (ofs.sf <= 0) ? 0 : 1;
  if ( ofs.lim < 0 )
    ofs.lim = XDEF_LIM;
  if ( ofs.padding < 0 )
    ofs.padding = ' '; /* blank */
  str = asprint_xpr (x, ofs.notat, ofs.sf, ofs.lim);
  errcode = xwprint (str, ofs.mfwd, ofs.padding, stdout);
  if ((str))
    free ((void*)str);
  return errcode;
}

/*
  Remark: xsout() returns an 'unsigned short' value
  casted to 'unsigned long'.
*/

unsigned long 
xsout (char *s, unsigned long n, struct xoutflags ofs, struct xpr x)
{
  char* str;
  unsigned long nw;

  ofs.notat = (ofs.notat <= 0) ? XOUT_FIXED : XOUT_SCIENTIFIC;
  ofs.sf = (ofs.sf <= 0) ? 0 : 1;
  if ( ofs.lim < 0 )
    ofs.lim = XDEF_LIM;
  if ( ofs.padding < 0 )
    ofs.padding = ' '; /* blank */
  str = asprint_xpr (x, ofs.notat, ofs.sf, ofs.lim);
  nw = xwsnprint (s, n, str, ofs.mfwd, ofs.padding);
  if ((str))
    free ((void*)str);  
  return nw; 
}
