/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include"cxpre.h" /* Automatically includes "xpre.h" */

extern int x_sgn (struct xpr x); /* see constant.c */

struct cxpr
cxsin (struct cxpr z)
{
  struct cxpr w1, w2;

  w1 = cxdrot (z);                /* Now w1= i*z,  where i={0,1} */
  w2 = cxrrot (z);                /* Now w2= -i*z, where i={0,1} */
  w1 = cxsub (cxexp (w1), cxexp (w2));
  w2.re = xpr2 (w1.im, -1);
  w1.re.nmm[0] ^= m_sgn;
  w2.im = xpr2 (w1.re, -1); /* Now w2= (exp(i*z)-exp(-i*z))/2i */
  return w2;
}

struct cxpr
cxcos (struct cxpr z)
{
  struct cxpr w1, w2;

  w1 = cxdrot (z); /* Now w1=  i*z,  where i={0,1} */
  w2 = cxrrot (z); /* Now w2= -i*z, where i={0,1} */
  w1 = cxsum (cxexp (w1), cxexp (w2));
  w2.re = xpr2 (w1.re, -1);
  w2.im = xpr2 (w1.im, -1);
  return w2;
}

struct cxpr
cxtan (struct cxpr z)
{
  if ( xsigerr (xprcmp (&z.im, &xEmax) > 0, XFPOFLOW, NULL) )
    return cxi;
  else if ( xsigerr (xprcmp (&z.im, &xEmin) < 0, XFPOFLOW, NULL) )
    return cxneg(cxi);
  else 
    {
      struct cxpr w;

      if ( xsigerr (!cxrec(cxcos(z), &w), XEDOM, "cxtan()") )
	return cx0;
      else
	return cxmul (cxsin (z), w);
    }
}

struct cxpr
cxasin (struct cxpr z)
{
  struct cxpr w;
  struct xpr ls, rs;

  w = cxsqrt (cxsub (cx1, cxsqr (z)));
  ls = cxabs (cxsum (cxdrot(z), w));
  rs = xmul (xVSV, cxabs (z));
  if ( xprcmp(&ls, &rs) < 0 )
    w = cxdrot(cxlog (cxsub (w, cxdrot(z))));
  else
    w = cxrrot(cxlog (cxsum (cxdrot(z), w)));
  return w;
}

struct cxpr
cxacos (struct cxpr z)
{
  struct cxpr w;
  struct xpr ls, rs;

  w = cxsqrt (cxsub (cx1, cxsqr (z)));
  ls = cxabs (cxsum (z, cxdrot(w)));
  rs = xmul (xVSV, cxabs(z));
  if ( xprcmp(&ls, &rs) < 0 )
    w = cxdrot(cxlog (cxsub (z, cxdrot(w))));
  else
    w = cxrrot(cxlog (cxsum (z, cxdrot(w))));
  return w;
}

struct cxpr
cxatan (struct cxpr z)
{
  struct cxpr w;
  struct xpr mod;
  int errcond;

  errcond = x_sgn (z.re) == 0 && x_sgn (xadd(xabs(z.im), one, 1)) == 0;
  if ( xsigerr (errcond, XEDOM, "cxatan()") )
    return cx0;
  else
    {
      /* In this way, cxatan() works fine also with complex numbers */
      /* very far from the origin.                                  */
      mod = cxabs (z);
      if ( xprcmp (&mod, &xVGV) > 0 )
	{
	  w = cxsqrt (cxsum (cx1, cxsqr (z)));
	  w = cxdiv  (cxsum (cx1, cxdrot(z)), w);
	  w = cxrrot (cxlog (w));
	}
      else
	{
	  w = cxdiv (cxsum (cx1, cxdrot(z)), cxsub (cx1, cxdrot(z)));
	  w = cxrrot(cxlog_sqrt (w));
	}
      return w;
    }
}
