/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include"cxpre.h" /* Automatically includes "xpre.h" */

int
cxis0 (struct cxpr z)
{
  return (xprcmp (&z.re, &zero) == 0 &&
	  xprcmp (&z.im, &zero) == 0);
}

int
cxnot0 (struct cxpr z)
{
  return (xprcmp (&z.re, &zero) != 0 ||
	  xprcmp (&z.im, &zero) != 0);
}

int
cxeq (struct cxpr z1, struct cxpr z2)
{
  return (xprcmp (&z1.re, &z2.re) == 0 &&
	  xprcmp (&z1.im, &z2.im) == 0);
}

int
cxneq (struct cxpr z1, struct cxpr z2)
{
  return (xprcmp (&z1.re, &z2.re) != 0 ||
	  xprcmp (&z1.im, &z2.im) != 0);
}

int
cxgt (struct cxpr z1, struct cxpr z2)
{
  int rs = xprcmp (&z1.re, &z2.re);
  int is = xprcmp (&z1.im, &z2.im);

  if ( rs > 0 )
    return (is >= 0);
  else if ( is > 0 )
    return (rs >= 0);
  else
    return 0;
}

int
cxge (struct cxpr z1, struct cxpr z2)
{
  return (xprcmp (&z1.re, &z2.re) >= 0 &&
	  xprcmp (&z1.im, &z2.im) >= 0);
}

int
cxlt (struct cxpr z1, struct cxpr z2)
{
  int rs = xprcmp (&z1.re, &z2.re);
  int is = xprcmp (&z1.im, &z2.im);

  if ( rs < 0 )
    return (is <= 0);
  else if ( is < 0 )
    return (rs <= 0);
  else
    return 0;
}

int
cxle (struct cxpr z1, struct cxpr z2)
{
  return (xprcmp (&z1.re, &z2.re) <= 0 &&
	  xprcmp (&z1.im, &z2.im) <= 0);
}
