/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include<stdlib.h>
#include<string.h>
#include<ctype.h>
#include"cxpre.h" /* Automatically includes "xpre.h" */

struct cxpr str2cx (const char* q, char** endptr)
{
  struct cxpr z = cx0;
  char *ptr, *ptr2;

  z.re = str2x (q, &ptr);
  if ( (endptr) )
    *endptr = ptr;
  if ( ptr != q )
    {
      if ( *ptr == CX1I_CHAR )
	{
	  z.im = z.re;
	  z.re = zero;
	  if ( (endptr) )
	    *endptr = ptr + 1;
	}
      else
	{
	  while ( isspace(*ptr) )
	    ptr++;
	  if (*ptr == '+' || *ptr == '-')
	    {
	      z.im = str2x (ptr, &ptr2);
	      if ( *ptr2 != CX1I_CHAR )
		z.im = zero;
	      else
		{
		  if ( (endptr) )
		    *endptr = ptr2 + 1;
		}
	    }
	  /*
	    else
	    : we have successfully read a real number
	    but there is no another number after it.
	    : So, we leave z.im to the value zero
	    and return z.
	  */
	}
    }
  /* 
     else
     : q does not contain any valid number
     ==> z.re is zero. Since also z.im is
     zero we can directly return this
     result. We remark that, if endptr is
     not NULL, then *endptr == q.
  */
  return z; 
}

struct cxpr atocx  (const char *s)
{
  return str2cx (s, NULL);
}

char* asprint_cxpr (struct cxpr z, int sc_not, int sign, int lim)
{
  char *str1, *str2, *t;

  str1 = asprint_xpr (z.re, sc_not, sign, lim);
  str2 = asprint_xpr (z.im, sc_not, 1, lim);
  if ( !str1 || ! str2 )
    return NULL;
  else
    {
      size_t n = strlen (str1) + strlen (str2) + 2;

      if ( !(t = malloc (n * sizeof(char))) )
	return NULL;
      else
	{
	  strcpy (t, str1);
	  strcat (t, str2);
	  for (n=0; t[n] != '\0'; n++);
	  t[n] = CX1I_CHAR;
	  t[n+1] = '\0';
	  return t;
	}
    }
}

char* cxtoa (struct cxpr z,int lim)
{
  return asprint_cxpr (z, 1, 0, lim);
}

struct cxpr dctocx (double re, double im)
{
  struct cxpr z;

  z.re = dbltox (re);
  z.im = dbltox (im);
  return z;
}

struct cxpr fctocx (float re, float im)
{
  struct cxpr z;

  z.re = flttox (re);
  z.im = flttox (im);
  return z;
}

struct cxpr ictocx (long re, long im)
{
  struct cxpr z;

  z.re = inttox (re);
  z.im = inttox (im);
  return z;
}

void cxtodc (const struct cxpr* z, double* re, double* im)
{
  *re = xtodbl (z->re);
  *im = xtodbl (z->im);
}

void cxtofc (const struct cxpr* z, float* re, float* im)
{
  *re = xtodbl (z->re);
  *im = xtodbl (z->im);
}
