/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include"cxpre.h" /* Automatically includes "xpre.h" */

extern int x_sgn (struct xpr x); /* see constant.c */

struct cxpr
cxreset (struct xpr re, struct xpr im)
{
  return (struct cxpr){re, im};
}

struct cxpr
cxconv (struct xpr x)
{
  return (struct cxpr){x, zero};
}

struct xpr
cxre (struct cxpr z)
{
  return z.re;
}

struct xpr
cxim (struct cxpr z)
{
  return z.im;
}

struct cxpr
cxswap (struct cxpr z)
{
  return (struct cxpr){z.im, z.re};
}

struct cxpr
cxneg (struct cxpr z)
{
  z.re.nmm[0] ^= m_sgn;
  z.im.nmm[0] ^= m_sgn;
  return z;
}

struct cxpr
cxconj (struct cxpr z)
{
  return (z.im.nmm[0] ^= m_sgn, z);
}

#define XBOUND  XDIM * 16 + 8

struct xpr
cxabs (struct cxpr z)
{
  struct xpr x;
  int ea, eb;
  
  if ( xprcmp (&z.re, &zero) == 0 &&
       xprcmp (&z.im, &zero) == 0 )
    return zero;
  else
    {
      ea = (z.re.nmm[0] &= m_exp) - bias;
      eb = (z.im.nmm[0] &= m_exp) - bias;
      if ( ea > eb + XBOUND )
	return z.re;
      else if ( eb > ea + XBOUND )
	return z.im;
      else
	{
	  z.re.nmm[0] -= eb;
	  z.im.nmm[0] = bias;
	  x = xsqrt (xadd (xmul(z.re, z.re), xmul (z.im, z.im), 0));
	  x.nmm[0] += eb;
	  return x;
	}
    }
}

struct xpr
cxarg (struct cxpr z)
{
  int rs, is;

  rs = x_sgn (z.re);
  is = x_sgn (z.im);
  if ( rs > 0 )
    return xatan ( xdiv (z.im, z.re) );
  else if ( rs < 0 )
    {
      z.re.nmm[0] ^= m_sgn;
      z.im.nmm[0] ^= m_sgn;
      if ( is >= 0 )
	return xadd (pi, xatan ( xdiv (z.im, z.re) ), 0);
      else
	return xadd ( xatan ( xdiv (z.im, z.re) ), pi, 1);
    }
  else /* z.re is zero ! */
    {
      if ( !xsigerr (is == 0, XEDOM, "cxarg()") )
	return ( is > 0 ? pi2 : xneg(pi2) );
      else
	return xneg(pi2); /* Dummy value :) */
    }
}

int cxrec (struct cxpr z, struct cxpr* w)
{
  struct xpr x;
  int sa, sb, ea, eb;
  
  if ( xprcmp (&z.re, &zero) == 0 &&
       xprcmp (&z.im, &zero) == 0 )
    return 0;
  else
    {
      sa = z.re.nmm[0] & m_sgn;
      sb = z.im.nmm[0] & m_sgn;
      ea = (z.re.nmm[0] &= m_exp) - bias;
      eb = (z.im.nmm[0] &= m_exp) - bias;
      if ( ea > eb + XBOUND )
	x = z.re;
      else if ( eb > ea + XBOUND )
	x = z.im;
      else
	{
	  z.re.nmm[0] -= eb;
	  z.im.nmm[0] = bias;
	  x = xsqrt (xadd (xmul(z.re, z.re), xmul (z.im, z.im), 0));
	  x.nmm[0] += eb;
	  z.re.nmm[0] += eb;
	  z.im.nmm[0] += eb;
	}
      w->re = xdiv (xdiv (z.re, x), x);
      w->im = xdiv (xdiv (z.im, x), x);
      w->re.nmm[0] |= sa;
      w->im.nmm[0] |= m_sgn ^ sb; 
      return 1;
    }
}

struct cxpr
cxfloor (struct cxpr z)
{
  struct cxpr w;

  w.re = xfloor (z.re);
  w.im = xfloor (z.im);
  return w;
}

struct cxpr
cxceil (struct cxpr z)
{
  struct cxpr w;

  w.re = xceil (z.re);
  w.im = xceil (z.im);
  return w;
}

struct cxpr
cxround (struct cxpr z)
{
  struct cxpr w;

  w.re = xround (z.re);
  w.im = xround (z.im);
  return w;
}

struct cxpr
cxtrunc (struct cxpr z)
{
  struct cxpr w;

  w.re = xtrunc (z.re);
  w.im = xtrunc (z.im);
  return w;
}

struct cxpr
cxfrac (struct cxpr z)
{
  struct cxpr w;

  w.re = xfrac (z.re); 
  w.im = xfrac (z.im);
  return w;
}
