/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

/*
    Test:  atox  prxpr  xprint

    Input file:  data/atox.dat
*/
#include<stdio.h>
#include "xpre.h"

int decd=30;

int main(int na,char **av)
{ 
  struct xpr f;
  FILE *fp;
  char num[256];

  if(na!=2)
    { 
      printf("para: input_file\n");
      exit(-1);
    }
  fp=fopen(*++av,"r");
  while(fscanf(fp,"%s",num)!=EOF)
    {
      printf(" string in : %s\n",num);

      /* convert ascii string to extended precision */
      f=atox(num);

      printf(" f =       "); prxpr(f,decd);
      printf(" hex =       "); xprint(f);
    }
  return 0;
}
/*  Test output

 string in : 1.25
 f =         1.250000000000000000000000000000e+0
 hex =       3fff.9ffffffffffffffffffffffffffe
 string in : 1.234567890123456789012345678901
 f =         1.234567890123456789012345678901e+0
 hex =       3fff.9e06521462cfdb8d3df0b5b5b437
 string in : 1.326457891245678800213456789012e+512
 f =         1.326457891245678800213456789011e+512
 hex =       46a4.969e8eb82353816d4739377f0d6c
 string in : -9.876543210123456789098765432108e-70
 f =        -9.876543210123456789098765432107e-70
 hex =       bf19.da2117a8c6ec0619ba34035d600f
 string in : 0.3333333333333333333333333333333
 f =         3.333333333333333333333333333333e-1
 hex =       3ffd.aaaaaaaaaaaaaaaaaaaaaaaaa8d5
 string in : 1.10e-3
 f =         1.100000000000000000000000000000e-3
 hex =       3ff5.902de00d1b71758e219652bd3c2d
 string in : -1.03e-3
 f =        -1.030000000000000000000000000000e-3
 hex =       bff5.870110a137f38c5436b8f9b1315e
 string in : -0.00103
 f =        -1.030000000000000000000000000000e-3
 hex =       bff5.870110a137f38c5436b8f9b13158
 string in : 1.326457891245678800213456789012e512
 f =         1.326457891245678800213456789011e+512
 hex =       46a4.969e8eb82353816d4739377f0d6c
 string in : +1.326457891245678800213456789012e-512
 f =         1.326457891245678800213456789011e-512
 hex =       395a.bf649bfe55c7cafbfa185972bf0d
 string in : .23456
 f =         2.345600000000000000000000000000e-1
 hex =       3ffc.f0307f23cc8de2ac322291fb3f8e
 string in : +12345
 f =         1.234500000000000000000000000000e+4
 hex =       400c.c0e4000000000000000000000000
 string in : 12345.
 f =         1.234500000000000000000000000000e+4
 hex =       400c.c0e4000000000000000000000000
 string in : +12e2
 f =         1.200000000000000000000000000000e+3
 hex =       4009.9600000000000000000000000000
 string in : 12e-2
 f =         1.200000000000000000000000000000e-1
 hex =       3ffb.f5c28f5c28f5c28f5c28f5c28f54
 string in : 12e+2
 f =         1.200000000000000000000000000000e+3
 hex =       4009.9600000000000000000000000000
 string in : 123.E4
 f =         1.230000000000000000000000000000e+6
 hex =       4013.9625800000000000000000000000
 string in : 123.E-4
 f =         1.230000000000000000000000000000e-2
 hex =       3ff8.c985f06f694467381d7dbf487fbb
 string in : 123.E+4
 f =         1.230000000000000000000000000000e+6
 hex =       4013.9625800000000000000000000000
 string in : 556.1234567890123456789012345678901234567890
 f =         5.561234567890123456789012345679e+2
 hex =       4008.8b07e6b74dd1bd97c70fe5a2af7c
 string in : +1234567890987654321033335555669876543210.234567788
 f =         1.234567890987654321033335555670e+39
 hex =       4080.e83248202a4ed957173e413ae677
 string in : 1234567890987654321033335555669876543210.1234567890123456789012345678901234567890
 f =         1.234567890987654321033335555670e+39
 hex =       4080.e83248202a4ed957173e413ae677
 string in : 0
 f =         0.000000000000000000000000000000e+0
 hex =       0000.0000000000000000000000000000
 string in : 0.
 f =         0.000000000000000000000000000000e+0
 hex =       0000.0000000000000000000000000000
 string in : .0
 f =         0.000000000000000000000000000000e+0
 hex =       0000.0000000000000000000000000000
 string in : 0.0
 f =         0.000000000000000000000000000000e+0
 hex =       0000.0000000000000000000000000000
 string in : +0.0E1000
 f =         0.000000000000000000000000000000e-3933
 hex =       0cf9.0000000000000000000000000000
 string in : 0E-5
 f =         0.000000000000000000000000000000e+0
 hex =       0000.0000000000000000000000000000
 string in : 2
 f =         2.000000000000000000000000000000e+0
 hex =       4000.8000000000000000000000000000
 string in : 2.00000000000000000000000
 f =         2.000000000000000000000000000000e+0
 hex =       4000.8000000000000000000000000000
 string in : 2.00000000000000000000031
 f =         2.000000000000000000000310000000e+0
 hex =       4000.8000000000000000005db1169848
 string in : -2
 f =        -2.000000000000000000000000000000e+0
 hex =       c000.8000000000000000000000000000
 string in : -2.0000000000000000000000
 f =        -2.000000000000000000000000000000e+0
 hex =       c000.8000000000000000000000000000
 string in : -2.00000000000000000000031
 f =        -2.000000000000000000000310000000e+0
 hex =       c000.8000000000000000005db1169848
 string in : 7
 f =         7.000000000000000000000000000000e+0
 hex =       4001.e000000000000000000000000000
 string in : 7.0000000000000000000
 f =         7.000000000000000000000000000000e+0
 hex =       4001.e000000000000000000000000000
 string in : 7.0000000000000000000045
 f =         7.000000000000000000004500000000e+0
 hex =       4001.e00000000000000002a805516a0d
 string in : -7
 f =        -7.000000000000000000000000000000e+0
 hex =       c001.e000000000000000000000000000
 string in : -7.0000000000000000000
 f =        -7.000000000000000000000000000000e+0
 hex =       c001.e000000000000000000000000000
 string in : -7.0000000000000000000045
 f =        -7.000000000000000000004500000000e+0
 hex =       c001.e00000000000000002a805516a0d
 string in : +8.99887766554433221E+1024
 f =         8.998877665544332209999999999989e+1024
 hex =       4d4b.e29e07ef4a8295912d36a679d213
 string in : -8.99887766554433221E+1024
 f =        -8.998877665544332209999999999989e+1024
 hex =       cd4b.e29e07ef4a8295912d36a679d213
 string in : +6.09876012345e4900
 f =         6.098760123449999999999999999965e+4900
 hex =       7f97.8515360b3d03a65425989b511484
 string in : -6.09876012345e4900
 f =        -6.098760123449999999999999999965e+4900
 hex =       ff97.8515360b3d03a65425989b511484
 string in : +9.87654321012333E5020
 f =         0.000000000000000000000000000000e+4932
 hex =       7fff.0000000000000000000000000000
 string in : -9.87654321012333E5020
 f =         0.000000000000000000000000000000e+4932
 hex =       7fff.0000000000000000000000000000
 string in : 4.987002345e+297
 f =         4.987002344999999999999999999998e+297
 hex =       43db.f40373b2a48bf00de1620865702a
 string in : -4.987002345e+297
 f =        -4.987002344999999999999999999998e+297
 hex =       c3db.f40373b2a48bf00de1620865702a
 string in : 756789012.000000
 f =         7.567890120000000000000000000000e+8
 hex =       401c.b46ebc5000000000000000000000
 string in : 7.56789012000000e+8
 f =         7.567890120000000000000000000000e+8
 hex =       401c.b46ebc4ffffffffffffffffffffe
 string in : 987.6543210123456789098765432101234567890987654321
 f =         9.876543210123456789098765432101e+2
 hex =       4008.f6e9e0653d470f3501679b5a936d
 string in : -.6543210123456789098765432101234567890987654321
 f =        -6.543210123456789098765432101234e-1
 hex =       bffe.a78194f51c3cd4059e6d6a4db511
*/
