/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include "xpre.h"

struct xpr xneg(struct xpr s)
{ 
  unsigned short *p=(unsigned short *)&s;
  
  *p^=m_sgn; return s;
}

struct xpr xabs(struct xpr s)
{ 
  unsigned short *p=(unsigned short *)&s;
  
  *p&=m_exp; return s;
}

int xex(struct xpr *ps)
{ 
  unsigned short *q=(unsigned short *)ps;
  
  return (*q&m_exp)-bias;
}

int neg(struct xpr *ps)
{ 
  unsigned short *q=(unsigned short *)ps;
  
  return (*q&m_sgn);
}
