/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include "config.h"
#include "xpre.h"

struct xpr xfmod(struct xpr s,struct xpr t,int *p)
{ 
  struct xpr h; unsigned short *q,*ph; short k;
  
  h=xdiv(s,t); ph=(unsigned short *)&h; k=(*ph&m_exp)-bias;
  if(k>=0){ rshift(31-k,ph+1,2);
    q=(unsigned short *)p;
    /* Change made by Ivano Primi - 11/19/2004 */
#ifdef XLITTLE_ENDIAN
    *(q+1)= *(ph+1); *q= *(ph+2);
#else
    *q= *(ph+1); *(q+1)= *(ph+2);
#endif
   }
  else *p=0;
  if(*p){ if(*ph&m_sgn) s=xadd(s,xmul(t,inttox(*p)),0);
          else s=xadd(s,xmul(t,inttox(*p)),1);
   }
  return s;
}

struct xpr xfrex(struct xpr s,int *p)
{ 
  unsigned short *ps=(unsigned short *)&s,u;
  
  *p=(*ps&m_exp)-bias+1; u= *ps&m_sgn;
  *ps=bias-1; *ps|=u; return s;
}
