/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

/* Constants file for XDIM=11
*/

const int itt_div=2;
const int k_tanh=6;
const int ms_exp=31;
const int ms_hyp=35;
const int ms_trg=43;
const short max_p=16*XDIM;
const short k_lin= -8*XDIM;

const struct xpr zero={0x0,0x0};
const struct xpr one={0x3fff,0x8000};
const struct xpr two={0x4000,0x8000};
const struct xpr ten={0x4002,0xa000};
const struct xpr x_huge={0x7fff,0x0};
const struct xpr pi4={0x3ffe,0xc90f,0xdaa2,0x2168,0xc234,0xc4c6,0x628b,0x80dc,
  0x1cd1,0x2902,0x4e08,0x8a68};
const struct xpr pi2={0x3fff,0xc90f,0xdaa2,0x2168,0xc234,0xc4c6,0x628b,0x80dc,
  0x1cd1,0x2902,0x4e08,0x8a68};
const struct xpr pi={0x4000,0xc90f,0xdaa2,0x2168,0xc234,0xc4c6,0x628b,0x80dc,
  0x1cd1,0x2902,0x4e08,0x8a68};
const struct xpr ee={0x4000,0xadf8,0x5458,0xa2bb,0x4a9a,0xafdc,0x5620,0x273d,
  0x3cf1,0xd8b9,0xc583,0xce2d};
const struct xpr ln2={0x3ffe,0xb172,0x17f7,0xd1cf,0x79ab,0xc9e3,0xb398,0x03f2,
  0xf6af,0x40f3,0x4326,0x7299};
const struct xpr srt2={0x3fff,0xb504,0xf333,0xf9de,0x6484,0x597d,0x89b3,0x754a,
  0xbe9f,0x1d6f,0x60ba,0x893c};
