<?
/*
 *   This file is part of The Horus Indexer.
 *
 *   The Horus Indexer is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   The Horus Indexer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with The Horus Indexer; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
********************************************************************************
 * Copyright (c) 2005 Jorge Barrera Grandon
 *
 */

require_once('inc/magicquotes.php');
require_once('inc/output.php');
require_once('inc/common.php');
require_once('conf/config.php');
require_once('lang/'.$conf['lang'].'/lang.php');

$DO   = $_REQUEST['do'];
$FILE = cleanpath($_REQUEST['file']);

define('BASE',getBaseURL());

if(@!file_exists($conf['basedir'].$FILE)){
  $FILE = '';
  header("HTTP/1.0 404 Not Found");
  out_print_header();
  print $lang['404'];
  print $lang['sorry'];
  out_print_footer();
  exit;
}


if($DO == 'download'){
  header('Content-type: application/octet-stream');
  header('Content-Disposition: attachment; filename="'.basename($FILE).'"');
  readfile($conf['basedir'].$FILE);
  exit;
}elseif($DO == 'view') {
  //display images
  if($type = imagetype($FILE)){
    header("Content-type: $type");
    readfile($conf['basedir'].$FILE);
    exit;
  }

  out_print_header();
  print '<div class="desc">';
  if($conf['rewrite'] == '1'){
      print '[<a href="'.out_link(BASE.'download',$FILE).'">'.$lang['download'].'</a>] '.$lang['thisfile'].'';
  }else{
      print '[<a href="'.out_link('download',$FILE).'">'.$lang['download'].'</a>] '.$lang['thisfile'].'';
  }
  print '</div>';
  print '<div class="view">';
  if($type = geshitype($FILE)){
    //highlight sourcecode with geshi
    require_once('inc/geshi.php');
    $geshi = new GeSHi(join('',file($conf['basedir'].$FILE)), $type, 'inc/geshi');
#    $geshi->enable_line_numbers(GESHI_NORMAL_LINE_NUMBERS);
    echo $geshi->parse_code();
  }elseif(texttype($FILE)){
    print '<pre>';
    readfile($conf['basedir'].$FILE);
    print '</pre>';
  }
  print '</div>';
  out_print_footer();
}else{
  out_print_header();
  out_print_description($FILE);
  out_browse_dir($FILE);
  out_print_footer();
}

?>
