<?
/*
 *   This file is part of The Horus Indexer.
 *
 *   The Horus Indexer is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   The Horus Indexer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with The Horus Indexer; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
********************************************************************************
 * Copyright (c) 2005 Jorge Barrera Grandon
 *
 */
function out_print_path($dir){
  global $conf;

  $paths = split('/',$dir);
  $path  = '';
  foreach ($paths as $p){
    if($path) $path .= '/';
    $path .= "$p";
    print '/';
    if(is_dir($conf['basedir'].$path)){
      print '<a href="'.out_link(BASE.'browse',$path).'">'.hsc($p).'</a>';
    }else{
      print hsc($p);
    }
  }
}

function out_print_description($dir){
  global $conf;
  if(@file_exists($conf['basedir']."$dir/.description")){
    print '<div class="desc">';
    readfile($conf['basedir']."$dir/.description"); 
    print '</div>';
  }
}

function out_print_header(){
  global $FILE;
  global $conf;
  global $lang;

  print '<'.'?xml version="1.0"?'.">\n";
  print '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 Strict//EN"';
  print ' "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">';
  print "\n";

  ?>
  <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en" dir="ltr">
  <head>
    <title>The Horus Indexer - <?=$conf['title']?>/<?=hsc($FILE)?></title>
    <meta http-equiv="Content-Type" content="text.php; charset=iso-8859-1" />
    <link rel="stylesheet" media="screen" type="text/css" href="<?=BASE?>tpl/default.css" />
    <link rel="shortcut icon" href="<?=BASE?>gfx/favicon.ico" />
  </head>
  <body>
  <div class="logo">
  <a href="<?=BASE?>index.php"><img src="<?=BASE?>gfx/img/logo.png" alt="The Horus Indexer" border="0" /></a>
  </div>
  <div class="head">
    <a href="<?=BASE?>index.php"><?=$conf['title']?></a>
    <i><?=out_print_path($FILE)?></i>
  </div>
  <?
}

function out_print_footer(){
  global $lang;
  print '<table border="0">';
  print '<tr>';
  print '<td class="blank">';
  print '<div class="bottom">'.$lang['powered'].'</div>';
  print '</td>';
  print '<td class="blank">';
  print '<div class="valid">';
  print '<a href="http://validator.w3.org/check?uri=referer">XHTML 1.1</a> '.$lang['and'].' <a href="http://jigsaw.w3.org/css-validator/check/referer">CSS 2.0</a>';
  print '</div>';
  print '</td>';
  print '</tr>';
  print '</table>';  
  print '</body>';
  print '</html>';
}

function out_browse_dir($dir){
  global $conf;
  global $lang;
  
  $full = $conf['basedir'].$dir;

  $dirs  = array();
  $files = array();

  $dh = opendir($full);
  while (($file = readdir($dh)) !== false) {
    if(preg_match('/^\./',$file)) continue; //skip hidden files and upper dirs
    if(@is_dir("$full/$file")){
      $dirs[]  = $file;
    }else{
      $files[] = $file;
    }
  }
  closedir($dh);
  natcasesort($dirs);
  natcasesort($files);

  if(@file_exists($full.'/.descript.ion')){
    $desc = read_descript_ion($full.'/.descript.ion');
  }
 
  print '<table cellspacing="0" border="0">';

  if($dir){
    if(preg_match('#/#',$dir)){
      $up = preg_replace('#/[^/]+?$#','',$dir);
    }else{
      $up = '';
    }
    
    if($conf['rewrite'] == '1'){
    out_print_trow( array('ico'  => BASE.'gfx/icons/backfolder.png',
                          'link' => out_link(BASE.'browse',"$up"),
                          'name' => $lang['back'],
			              'desc' => $lang['desc']));
    }else{
     out_print_trow( array('ico'  => BASE.'gfx/icons/backfolder.png',
                           'link' => out_link('browse',"$up"),
                           'name' => $lang['back'],
                           'desc' => $lang['desc']));
    }
         
    }
    
    if($conf['rewrite'] == '1'){
  foreach ($dirs as $f){
    out_print_trow( array('ico'  => BASE.'gfx/icons/folder.png',
                          'link' => out_link(BASE.'browse',"$dir/$f"),
                          'name' => hsc($f),
                          'date' => @filemtime($conf['basedir']."$dir/$f"),
			              'desc' => $desc[$f] ));
        }
    }else{
        foreach ($dirs as $f){        
    out_print_trow( array('ico'  => BASE.'gfx/icons/folder.png',
                          'link' => out_link('browse',"$dir/$f"),
                          'name' => hsc($f),
                          'date' => @filemtime($conf['basedir']."$dir/$f"),
                          'desc' => $desc[$f] ));
    }
           
  }

  foreach ($files as $f){
    out_print_trow( array('ico'  => out_icon("$dir/$f"),
                          'name' => hsc($f),
                          'down' => out_download("$dir/$f"),
                          'view' => out_view("$dir/$f"),
                          'size' => @filesize($conf['basedir']."$dir/$f"),
                          'date' => @filemtime($conf['basedir']."$dir/$f"),
			  'desc' => $desc[$f] ));
  }
  print '<tr><td class="blank"></td></tr>';
  print '</table>';
}

function out_print_trow($i){
    global $conf;
  print '<tr>';

  print '<td class="ico">';
  print '<img src="'.$i['ico'].'" width="16" height="16" alt="dir" />';
  print '</td>';

  print '<td class="name">';
  if($i['link']){
    print '<a href="'.$i['link'].'">';
    print $i['name'];
    print '</a>';
  }else{
    print $i['name'];
  }
  print '</td>';

  print '<td class="description">';
  if (hsc($i['desc'])) {
      print hsc($i['desc']);
  }else{
      print '&nbsp;';
  }
  print '</td>';

  print '<td class="date">';
  if($i['date']) {
      print date($conf['date'],$i['date']);
  }else{
      print '&nbsp;';
  }
  print '</td>';

  print '<td class="size">';
  if($i['size']){
      print filesize_h($i['size']);
  }else{
      print '&nbsp;';
  }
  print '</td>';
  if ($i['view']) {
      print '<td class="view">'.$i['view'].'</td>';
  }else{
      print '<td class="view">&nbsp;</td>';
  }
  if ($i['down']) {
      print '<td class="down">'.$i['down'].'</td>';
  }else{
      print '<td class="down">&nbsp;</td>';
  }


  print '</tr>';
}

function out_icon($file){
  if(preg_match('/\.([\w]+?)$/',$file,$matches)){
    $ext = strtolower($matches[1]);
  }else{
    $ext = 'blank';
  }

  if(!@file_exists("gfx/icons/$ext.png")){
    $ext = 'unknown';
  }

  return BASE.'gfx/icons/'.$ext.'.png';
}

function out_link($do,$file){
  global $conf;
  $file = cleanpath($file);
  $file = urlencode($file);
  $file = str_replace('%2F','/',$file);

  if($conf['rewrite']){
    $link = $do.'/'.$file;
  }else{
    $link = BASE.'index.php?do='.$do.'&amp;file='.$file;
  }
  return $link;
}

  
  function out_download($file){
  global $conf;
  global $lang;
  $full = $conf['basedir'].$file;

  $ret = '';
  if(is_readable($full)){
      if($conf['rewrite'] == '1'){
    $ret .= ' [<a href="'.out_link(BASE.'download',$file).'" title="'.$lang['downfile'].'">'.$lang['download'].'</a>] ';
    }else{
        $ret .= ' [<a href="'.out_link('download',$file).'" title="'.$lang['downfile'].'">'.$lang['download'].'</a>] ';
    }
  } 

  return $ret;
    
}

function out_view($file){
  global $conf;
  global $lang;
  $full = $conf['basedir'].$file;

  $ret = '';
  if(is_readable($full)){
    if(geshitype($file) || imagetype($file) || texttype($file)){
        if($conf['rewrite'] == '1'){
      $ret .= ' [<a href="'.out_link(BASE.'view',$file).'" title="'.$lang['viewfile'].'">'.$lang['view'].'</a>] ';
        }else{
            $ret .= ' [<a href="'.out_link('view',$file).'" title="'.$lang['viewfile'].'">'.$lang['view'].'</a>] ';
            }
    }
  }

  return $ret;
}



?>
