<?
/*
 *   This file is part of The Horus Indexer.
 *
 *   The Horus Indexer is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   The Horus Indexer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with The Horus Indexer; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
********************************************************************************
 * Removes magic quotes
********************************************************************************
 * Copyright (c) 2005 Jorge Barrera Grandon
 *
 */

if (get_magic_quotes_gpc()) {
  if (!empty($_GET))    remove_magic_quotes($_GET);
  if (!empty($_POST))   remove_magic_quotes($_POST);
  if (!empty($_COOKIE)) remove_magic_quotes($_COOKIE);
  if (!empty($_REQUEST)) remove_magic_quotes($_REQUEST);
  if (!empty($_SESSION)) remove_magic_quotes($_SESSION);
  ini_set('magic_quotes_gpc', 0);
}
set_magic_quotes_runtime(0);
 
function remove_magic_quotes(&$array) {
  foreach (array_keys($array) as $key) {
    if (is_array($array[$key])) {
      remove_magic_quotes($array[$key]);
    }else {
      $array[$key] = stripslashes($array[$key]);
    }
  } 
}
?>
