;;; scholium.el -- code to load the scholium system

;; Copyright (C) 2005 Joe Corneli <jcorneli@math.utexas.edu>

;; Time-stamp: <jac -- Sun Jun 26 10:17:06 CDT 2005>

;; This file is not part of GNU Emacs, but it is distributed under
;; the same terms as GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary

;;; Code:

(defun load-scholium-system (&optional hdm-path)
  (interactive)
  (let ((livep (buffer-live-p "scholium-rewrite.tex")))
    (save-excursion
      (if livep 
          (set-buffer name)
        (find-file (concat (or hdm-path
                               (file-name-directory (expand-file-name "./")))
                           "scholium-system/scholium-rewrite.tex")))
      (goto-char (point-max))
      (let ((beg (progn (search-backward "\\begin{verbatim}")
                        (match-end 0)))
            (end (progn (search-forward "\\end{verbatim}")
                        (match-beginning 0))))
        (eval-region beg end)
        (lit-eval))
      (unless livep
        (kill-buffer (current-buffer))))))

(provide 'scholium)

;;; scholium.el ends here