;;; hdm-docs.el -- code for working with "The HDM Project" docs

;; Copyright (C) 2004 Joseph Corneli <jcorneli@math.utexas.edu>

;; Time-stamp: <jac -- Sun Jun 26 14:58:07 CDT 2005>

;; This file is not part of GNU Emacs, but it is distributed under
;; the same terms as GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;;; Code:


(defvar hdm-uname "Joe Corneli")
(defvar hdm-email "jcorneli@math.utexas.edu")
(defvar hdm-initials "jac")

(defun add-hdm-licensing (description)
  (interactive "MDescription: ")
  (save-excursion
    (let* ((fname (file-name-nondirectory (buffer-file-name)))
           (comment comment-start)
           (content (with-temp-buffer
                      (insert
                       ";;; " fname " -- " description
                       "\n\n"
                       ";; Copyright (C) 2005 " hdm-uname 
                       " <" hdm-email ">

;; Time-stamp: <" hdm-initials " -- Tue Jun 14 20:32:44 CDT 2005>

;; You can copy, distribute and/or modify this document under the
;; terms of the GNU General Public License version 2 (GPL); or the GNU
;; Free Documentation License Version 1.2 (FDL), with no Invariant
;; Sections, no Front-Cover Texts, and no Back-Cover Texts; or any
;; later version of either of these licenses that is published by the
;; Free Software Foundation.

%% You should have received text versions of the GPL and FDL along
%% with this file.  In addition, a copy of the FDL can be found in our
%% report \"The HDM Project\" (which this document is part of), in the
%% section entitled \"GNU Free Documentation License\".  If you have not
%% received a copy of these licenses, write to the Free Software
%% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
%% 02110-1301 USA

;; DISCLAIMER: The contents of this file are is distributed in the
;; hope that it will be useful, but WITHOUT ANY WARRANTY; without even
;; the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
;; PURPOSE.  See the GNU General Public License for more details.

;;; Commentary:

;;; Code:\n")
                      (goto-char (point-min))
                      (while (re-search-forward "^;+" nil t)
                        (replace-match
                         (let ((result ""))
                           (dotimes (i 
                                     (length (match-string 0)))
                             (setq result
                                   (concat comment result)))
                           result)))
                      (buffer-string))))
      (goto-char (point-min))
      (insert content)
      (goto-char (point-max))
      (insert "\n"  (replace-regexp-in-string ";" 
                                              comment-start
                                              ";;; ") 
              fname " ends here"))))

(defun add-elisp-licensing (description)
  (interactive "MDescription: ")
  (save-excursion
    (let* ((fname (file-name-nondirectory (buffer-file-name)))
           (comment comment-start)
           (content (with-temp-buffer
                      (insert
                       ";;; " fname " -- " description
                       "\n\n"
                       ";; Copyright (C) 2005 " hdm-uname 
                       " <" hdm-email ">

;; Time-stamp: <" hdm-initials " -- Tue Jun 14 20:32:44 CDT 2005>

;; This file is not part of GNU Emacs, but it is distributed under
;; the same terms as GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary

;;; Code:\n")
                      (goto-char (point-min))
                      (while (re-search-forward "^;+" nil t)
                        (replace-match
                         (let ((result ""))
                           (dotimes (i 
                                     (length (match-string 0)))
                             (setq result
                                   (concat comment result)))
                           result)))
                      (buffer-string))))
      (goto-char (point-min))
      (insert content)
      (goto-char (point-max))
      (insert "\n"  (replace-regexp-in-string ";" 
                                              comment-start
                                              ";;; ") 
              fname " ends here"))))

(defun begin-latex-document (&optional report)
  (interactive)
  (insert "\\documentclass[12pt]{" (if report
                                       "report"
                                     "article")
          "}

\\usepackage{beton}
\\usepackage{concmath}

\\usepackage{simplemargins}
\\setleftmargin{1in}
\\setrightmargin{1in}
\\settopmargin{1.5in}
\\setbottommargin{.5in}

\\usepackage[normalem]{ulem}
\\usepackage{amssymb}
\\usepackage[mathscr]{euscript}
\\usepackage[T1]{fontenc}
\\usepackage{amsmath}
\\usepackage{amsopn}
\\usepackage{amstext}
\\usepackage{amsthm}

\\parindent = 1.2em

\\theoremstyle{definition}   		
\\newtheorem{prop}{Proposition} 
\\newtheorem{nota}{Note}[section]
\\newtheorem{rem}{Editorial Remark}[section]
\\newtheorem{lem}{Lemma}   	
\\newtheorem{thm}{Theorem}
\\newtheorem{cor}{Corollary}
\\newtheorem{con}{Conjecture}

\\usepackage{verbatim}
\\makeatletter
\\newenvironment{lisp}
  {\\let\\ORGverbatim@font\\verbatim@font
   \\def\\verbatim@font{\\ttfamily\\scshape}%
   \\verbatim}
  {\\endverbatim
  \\let\\verbatim@font\\ORGverbatim@font}
\\makeatother

% What I would really like to do would be to make this
% text invisible.
\\makeatletter
\\newenvironment{hlisp}
  {\\let\\ORGverbatim@font\\verbatim@font
   \\def\\verbatim@font{\\ttfamily\\scshape}%
   \\verbatim}
  {\\endverbatim
  \\let\\verbatim@font\\ORGverbatim@font}
\\makeatother

\\makeatletter
\\newenvironment{idea}
  {\\let\\ORGverbatim@font\\verbatim@font

   \\def\\verbatim@font{\\ttfamily\\slshape}%
   \\verbatim}
  {\\endverbatim
  \\let\\verbatim@font\\ORGverbatim@font}
\\makeatother

\\newenvironment{notate}[1]
  {\\begin{nota}[{\\bf {\\em #1}}]}%
  {\\end{nota}}

\\newenvironment{note}[1]
  {\\begin{nota}[{\\bf {\\em #1}}]}%
  {\\end{nota}}

\\newenvironment{edit}[1]
  {\\begin{rem}[{\\bf {\\em #1}}]\\sl}%
  {\\normalfont\\end{rem}}

\\newcommand{\\comm}[1]{
\\sf \\fbox{\\begin{minipage}{.75\\textwidth}#1\\end{minipage}} \\normalfont}

\\newcommand{\\inp}[1]{\\sl#1\\normalfont}


\\begin{document}

\\end{document}")
  (goto-char (line-beginning-position))
  (previous-line 1))

(defun build-hdm-doc ()
  (interactive)
  (find-file "the-hdm-project.tex")
  (erase-buffer)
  (begin-latex-document t)
  (dolist (file '("../report/the-hdm-report-front.tex"
                  "../report/the-hdm-report-intro.tex"
                  "../scholium-system/scholium-rewrite.tex"
                  "../scholium-system/scholium-part-two.tex"
                  "../scholium-system/scholium-third.tex"
                  "../scholium-system/scholium-preliminaries.tex"
                  "../scholium-system/scholium-design.tex"
                  "../parsing/tts-overview.tex"
                  "../parsing/parser-design.tex"
                  "../convenience/convenient-design.tex"
                  "../report/fdl.tex"))
    (find-file file)
    (let ((contents (buffer-string)))
      (kill-buffer (current-buffer))
      (insert 
       (with-temp-buffer 
         (insert contents)
         (goto-char (point-min))
         (when (search-forward "\\begin{document}" nil t)
           (delete-region (point-min) (point))
           (search-forward "\\title")
           (replace-match "\\\\chapter")
           (search-forward "\\author{" nil t)
           (replace-match "by ")
           (search-forward "\\thanks")
           (let ((beg (match-beginning 0)))
             (search-forward "}}" nil t)
             (delete-region beg (point)))
           (search-forward "\\date")
           (replace-match "\\\\noindent")
           (search-forward "\\maketitle")
           (replace-match "")
           (search-forward "\\abstract")
           (replace-match "\\\\paragraph{Abstract.}")
           (search-forward "\\tableofcontents" nil t)
           (replace-match "")
           (search-forward "\\end{document}")
           (replace-match ""))
         (buffer-string)))))
  (add-hdm-licensing "documentation of the HDM project")
  (write-file "the-hdm-project.tex"))

;;; hdm-docs.el ends here
