;;; tts-continuation.el -- functions that assist `parser' from tts.el

;; Copyright (C) 2005 Joe Corneli <jcorneli@math.utexas.edu>

;; Time-stamp: <jac -- Sun Jun 26 10:13:37 CDT 2005>

;; This file is not part of GNU Emacs, but it is distributed under
;; the same terms as GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;;; Code:

(require 'tts-utils)

(defun parser-1-continuation ()
  (cond 
   ((let ((p1 (priority (greedy-operator (car tokens))))
          (p2 (priority current)))
      (and p1 p2 (eq p1 p2)))
    (let ((continuation (parser-1 (cdr tokens)
                                  (greedy-operator (car tokens)))))
      (setq elements (protect-append elements (first continuation))
            tokens (second continuation))))
   ;; we have discovered a symbol sitting next to something else.
   ;; This means that they have the high-priority *~ operator 
   ;; between them.
   ((member (car tokens) '("^" "_"))
    (let ((continuation (parse-sub/sup-script (cdr tokens))))
      (setq elements (list (operator (car tokens))
                           elements
                           (first continuation))
            tokens (second continuation)
            parens 'script))
    ;; replay!
    (parser-1-continuation))
   ;; can this do *all* the function application stuff?
   ;; Will this work, in general (doesn't it need some 
   ;; more testing to rule out other weird cases
   ;; involving parens?)?
   ((member (car tokens) '("(" "{" "["))
    (let ((continuation (parse-parens tokens nil nil)))
      (setq elements (list elements
                           (first continuation))
            tokens (second continuation)
            parens 'function))
    ;; replay!
    (parser-1-continuation))
   ;; bildung
   ((eq current '*~)
    (let ((continuation (parser-1 tokens '*~)))
      (setq elements (protect-append elements (first continuation))
            tokens (second continuation))))
   ;; I'm suspicious of this case, but it seems to be
   ;; needed to deal with RHSs that contain implicit
   ;; multiplication
   ((and (just-a-symbol-p (car tokens))
         elements)
;         (cond ((and (listp elements) 
;;                     (not (eq (car elements) '*~))
;                     )
;                t)
;               ((not (listp elements))
;                t)
;               (t
;                nil)))
    (let ((continuation (parser-1 tokens '*~)))
      (when (first continuation)
        (setq elements
              (cons '*~ 
                    ;; depending on the context, we want a `list' here
                    ;; instead of a `protect-append'
                    (cond ((let ((pp (or parens (third continuation))))
                             (when pp
                               (not (eq pp t))))
;                                   'script)
;                               (eq (third continuation)
;                                   'implicit)
;                               (eq 
;                                   'script))
                           (list elements 
                                 (first continuation)))
                          (t
                           (protect-append elements 
                                           (first continuation)))
                          ))
              tokens (second continuation)
              parens 'implicit))))))

(provide 'tts-continuation)
;;; tts-continuation.el ends here
