/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004, 2005, 2007 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <gtk/gtk.h>
#include "utils.h"
#include "preferences.h"

extern GtkWidget *window;
extern preferencestype preferences;

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

void
preview_update (GtkFileChooser *chooser, gpointer data)
{
	GtkWidget *image;
	gchar *filename;
	gboolean have_preview = FALSE;
	GdkPixbuf *pixbuf;

	filename = gtk_file_chooser_get_preview_filename (chooser);
	if (filename)
	{
		pixbuf = gdk_pixbuf_new_from_file_at_size (filename, 150, 150, NULL);
		g_free (filename);
		if (pixbuf)
		{
			have_preview = TRUE;
			image = gtk_image_new_from_pixbuf (pixbuf);
			gtk_file_chooser_set_preview_widget (chooser, image);
			g_object_unref (pixbuf);
		}
	}
	gtk_file_chooser_set_preview_widget_active (chooser, have_preview);
}

/* clean all entries, do not touch any toolbar entries */
void clearall (void)
{
	GtkWidget *nrentry, *descriptionentry, *typecombo, *materialcombo,
		*periodcombo, *notes, *dateentry, *valueentry, *referenceentry,
		*finddateentry, *locationentry, *coordinatesentry, *spotnotes, 
		*image1entry, *image2entry, *imagebutton1, *imagebutton2;
	GtkTextBuffer *buffer;
	GtkTextIter start, end;

	nrentry = lookup_widget (window, "nrentry");
	descriptionentry = lookup_widget (window, "descriptionentry");
	typecombo = lookup_widget (window, "typecombo");
	materialcombo = lookup_widget (window, "materialcombo");
	periodcombo = lookup_widget (window, "periodcombo");
	notes = lookup_widget (window, "notes");
	dateentry = lookup_widget (window, "dateentry");
	valueentry = lookup_widget (window, "valueentry");
	referenceentry = lookup_widget (window, "referenceentry");

	finddateentry = lookup_widget (window, "finddateentry");
	locationentry = lookup_widget (window, "locationentry");
	coordinatesentry = lookup_widget (window, "coordinatesentry");
	spotnotes = lookup_widget (window, "spotnotes");

	image1entry = lookup_widget (window, "image1entry");
	image2entry = lookup_widget (window, "image2entry");
	imagebutton1 = lookup_widget (window, "imagebutton1");
	imagebutton2 = lookup_widget (window, "imagebutton2");

	gtk_editable_delete_text (GTK_EDITABLE (nrentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (descriptionentry), 0, -1);
	gtk_combo_box_set_active (GTK_COMBO_BOX (typecombo), -1);
	gtk_combo_box_set_active (GTK_COMBO_BOX (materialcombo), -1);
	gtk_combo_box_set_active (GTK_COMBO_BOX (periodcombo), -1);
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (notes));
	gtk_text_buffer_get_start_iter (buffer, &start);
	gtk_text_buffer_get_end_iter (buffer, &end);
	gtk_text_buffer_delete (buffer, &start, &end);
	gtk_editable_delete_text (GTK_EDITABLE (dateentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (valueentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (referenceentry), 0, -1);

	gtk_editable_delete_text (GTK_EDITABLE (finddateentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (locationentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (coordinatesentry), 0, -1);
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (spotnotes));
	gtk_text_buffer_get_start_iter (buffer, &start);
	gtk_text_buffer_get_end_iter (buffer, &end);
	gtk_text_buffer_delete (buffer, &start, &end);

	gtk_editable_delete_text (GTK_EDITABLE (image1entry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (image2entry), 0, -1);
	gtk_container_foreach (GTK_CONTAINER(imagebutton1),
		(GtkCallback)gtk_widget_destroy, NULL);
	gtk_container_foreach (GTK_CONTAINER(imagebutton2),
		(GtkCallback)gtk_widget_destroy, NULL);
}

/* set popdown strings */
void set_combostrings (void)
{
	GtkWidget *combo, *old, *hbox;
	gchar **split;
	gint i;

	old = lookup_widget (window, "periodcombo");
	if (old) gtk_widget_destroy (old);
	combo = gtk_combo_box_new_text ();
	gtk_widget_show (combo);
	hbox = lookup_widget (window, "hbox25");
	gtk_box_pack_start (GTK_BOX (hbox), combo, TRUE, TRUE, 0);
	split = g_strsplit (preferences.periods, ",", 0);
	i = 0;
	while (split[i])
	{
		g_strstrip (split[i]);
		gtk_combo_box_append_text (GTK_COMBO_BOX(combo), split[i]);
		i++;
	}
	g_strfreev (split);
	GLADE_HOOKUP_OBJECT (window, combo, "periodcombo");

	old = lookup_widget (window, "materialcombo");
	if (old) gtk_widget_destroy (old);
	combo = gtk_combo_box_new_text ();
	gtk_widget_show (combo);
	hbox = lookup_widget (window, "hbox11");
	gtk_box_pack_start (GTK_BOX (hbox), combo, TRUE, TRUE, 0);
	split = g_strsplit (preferences.materials, ",", 0);
	i = 0;
	while (split[i])
	{
		g_strstrip (split[i]);
		gtk_combo_box_append_text (GTK_COMBO_BOX(combo), split[i]);
		i++;
	}
	g_strfreev (split);
	GLADE_HOOKUP_OBJECT (window, combo, "materialcombo");

	old = lookup_widget (window, "typecombo");
	if (old) gtk_widget_destroy (old);
	combo = gtk_combo_box_new_text ();
	gtk_widget_show (combo);
	hbox = lookup_widget (window, "hbox4");
	gtk_box_pack_start (GTK_BOX (hbox), combo, TRUE, TRUE, 0);
	split = g_strsplit (preferences.types, ",", 0);
	i = 0;
	while (split[i])
	{
		g_strstrip (split[i]);
		gtk_combo_box_append_text (GTK_COMBO_BOX(combo), split[i]);
		i++;
	}
	g_strfreev (split);
	GLADE_HOOKUP_OBJECT (window, combo, "typecombo");
}
