/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004, 2005 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include "callbacks.h"
#include "support.h"
#include "preferences.h"
#include "gui_utils.h"
#include "db.h"

extern GtkWidget *window;
extern preferencestype preferences;

gboolean
on_preferencesdialog_delete_event      (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gtk_widget_set_sensitive (window, 1);
	return FALSE;
}


void
on_preferencescancelbutton_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_set_sensitive (window, 1);
	gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET(button)));
}


void
on_preferencesokbutton_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *preferencesdialog, *ptypesentry, *pmaterialsentry, *pperiodsentry;
	GtkWidget *p1, *p2, *p3, *p4, *p5, *p6, *p7, *p8, *p9, *p10, *p11, *p12, *p13, *p14, *p15;
	gboolean check;
	gchar **states;
	gint i;
	GtkWidget *entry;
	gchar *line;
	gint nr;
	

	preferencesdialog = gtk_widget_get_toplevel (GTK_WIDGET(button));
	ptypesentry = lookup_widget (preferencesdialog, "ptypesentry");
	pmaterialsentry = lookup_widget (preferencesdialog, "pmaterialsentry");
	pperiodsentry = lookup_widget (preferencesdialog, "pperiodsentry");

	preferences.types = gtk_editable_get_chars (GTK_EDITABLE (ptypesentry), 0, -1);
	preferences.materials = gtk_editable_get_chars (GTK_EDITABLE (pmaterialsentry), 0, -1);
	preferences.periods = gtk_editable_get_chars (GTK_EDITABLE (pperiodsentry), 0, -1);
	set_combostrings ();

	/* refresh the combostrings */
	entry = lookup_widget (window, "entry");
	line = gtk_editable_get_chars (GTK_EDITABLE(entry), 0, -1);
	nr = atoi (line);
	if (nr > 1)
	{
		clearall ();
		load_from_db (nr);
	}
	g_free (line);

	p1 = lookup_widget (preferencesdialog, "p1");
	p2 = lookup_widget (preferencesdialog, "p2");
	p3 = lookup_widget (preferencesdialog, "p3");
	p4 = lookup_widget (preferencesdialog, "p4");
	p5 = lookup_widget (preferencesdialog, "p5");
	p6 = lookup_widget (preferencesdialog, "p6");
	p7 = lookup_widget (preferencesdialog, "p7");
	p8 = lookup_widget (preferencesdialog, "p8");
	p9 = lookup_widget (preferencesdialog, "p9");
	p10 = lookup_widget (preferencesdialog, "p10");
	p11 = lookup_widget (preferencesdialog, "p11");
	p12 = lookup_widget (preferencesdialog, "p12");
	p13 = lookup_widget (preferencesdialog, "p13");
	p14 = lookup_widget (preferencesdialog, "p14");
	p15 = lookup_widget (preferencesdialog, "p15");

	states = g_new0 (gchar *, 16);
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p1));
	states[0] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p2));
	states[1] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p3));
	states[2] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p4));
	states[3] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p5));
	states[4] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p6));
	states[5] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p7));
	states[6] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p8));
	states[7] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p9));
	states[8] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p10));
	states[9] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p11));
	states[10] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p12));
	states[11] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p13));
	states[12] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p14));
	states[13] = g_strdup (check ? "1" : "0");
	check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(p15));
	states[14] = g_strdup (check ? "1" : "0");
	states[15] = NULL;

	preferences.colvisible = g_strjoinv (",", states);

	for (i = 0; i < 15; i++)
		g_free (states[i]);
	g_free (states);

	gtk_widget_set_sensitive (window, 1);
	gtk_widget_destroy (preferencesdialog);
}

