/*
 * $Id: page.h,v 1.10 2003/10/05 19:58:30 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __FEM_PAGE_T__
#define __FEM_PAGE_T__


/*-----------------------------------------------------------------------------
                                 P A G E _ T 
-----------------------------------------------------------------------------*/

typedef struct page_t
{
	unsigned long		size;	/* max number of element */
	unsigned long		nb;	/* real number of element */
	unsigned long		first;  /* number of first element */
	int			flags;
	struct page_t		*next;
	void			*content;
} page_t;


/*-----------------------------------------------------------------------------
                          P A G E _ l I S T _ T
-----------------------------------------------------------------------------*/

typedef struct page_list_t
{
	unsigned long		nb;
	page_t			*first;
	page_t			*last;
	unsigned long		default_size;
	size_t			element_size;
	void			(*print)(void *);	/* TODO */
} page_list_t;


#define PAGE_FREEABLE		1
#define PAGE_DEFAULT_SIZE	8192


/*-----------------------------------------------------------------------------
                            P A G E _ F U N C _ T 
-----------------------------------------------------------------------------*/

typedef void (*page_func_t)(void *);


/*-----------------------------------------------------------------------------
                         P A G E _ F U N C _ U S P _ T
-----------------------------------------------------------------------------*/

typedef void (*page_func_us_t)(void *, unsigned short);


/*-----------------------------------------------------------------------------
                          P A G E _ F U N C _ P _ T
-----------------------------------------------------------------------------*/

typedef void (*page_func_p_t)(void *, void *);


/*-----------------------------------------------------------------------------
                         P A G E _ F U N C _ U S P _ T
-----------------------------------------------------------------------------*/

typedef void (*page_func_usp_t)(void *, unsigned short, void *);


/*-----------------------------------------------------------------------------
                         P A G E _ F U N C _ U L P _ T
-----------------------------------------------------------------------------*/

typedef void (*page_func_ulp_t)(void *, unsigned long, void *);


/*-----------------------------------------------------------------------------
                       P A G E _ S E A R C H _ U L _ T
-----------------------------------------------------------------------------*/

typedef int(*page_search_ul_t)(void *, unsigned long);


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S 
-----------------------------------------------------------------------------*/

extern page_list_t __fem_page_list_new(size_t element_size);
extern page_list_t __fem_page_list_copy(const page_list_t *list);
extern void __fem_page_list_free(page_list_t *list);
extern void *__fem_page_list_get_n(const page_list_t *list, unsigned long n);
extern void *__fem_page_list_add(page_list_t *list);
extern void *__fem_page_list_add_content(page_list_t *list,
					 const void *content);
extern void __fem_page_list_add_v(page_list_t *list, void *content,
				  unsigned long n);
extern void __fem_page_list_remove_last(page_list_t *list);
extern void __fem_page_list_loop(const page_list_t *list, page_func_t f);
extern void __fem_page_list_loop_us(const page_list_t *list,
				    page_func_us_t f,
				    unsigned short us);
extern void __fem_page_list_loop_p(const page_list_t *list,
				   page_func_p_t f,
				   void * data);
extern void __fem_page_list_loop_usp(const page_list_t *list,
				     page_func_usp_t f,
				     unsigned short us, void *data);
extern void __fem_page_list_loop_ulp(const page_list_t *list,
				     page_func_ulp_t f,
				     unsigned long ul, void *data);
extern unsigned long __fem_page_list_search_ul(const page_list_t *list,
					       page_search_ul_t f,
					       unsigned long ul);

#endif /* __FEM_PAGE_T__ */
