/*
 * $Id: numbering.h,v 1.4 2003/10/05 19:59:12 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __FEM_NUMBERING_H__
#define __FEM_NUMBERING_H__

#include "dof.h"
#include "meshing.h"


/*-----------------------------------------------------------------------------
                            N U M B E R I N G _ T 
-----------------------------------------------------------------------------*/

/*
 * Meshing : 
 *
 *       1---4
 *      / \ /
 *     2---3
 *
 * NOTE: n of node are node->n
 *
 * 2 dof per node
 *
 * total = 8
 *      DOF#0  DOF#1
 *      pos[0] pos[1]
 * 
 * N1     1      2
 * N2     3      4
 * N3     5      6
 * N4     7      8
 *
 */

typedef struct numbering_t
{
	unsigned long	dof;		/* total nb of dof */
	unsigned long	bc;		/* total nb of bc */
	unsigned long	*row[DOF_MAX];
	unsigned long	*lambda1;
	unsigned long	*lambda2;
} numbering_t;


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S 
-----------------------------------------------------------------------------*/

#include "bc.h"
#include "element.h"


extern int __fem_numbering_create(numbering_t *numbering,
				  const meshing_t *meshing,
				  const struct element_t *element,
				  const bc_list_t *bc_list);

extern void __fem_numbering_free(numbering_t *numbering);

extern unsigned long __fem_numbering_global(const numbering_t *numbering,
					    const meshing_t *meshing,
					    unsigned long n, const char *dof);
extern dof_t __fem_numbering_local(const numbering_t *numbering,
				   const meshing_t *meshing,
				   unsigned long no,
				   unsigned long dof);

#endif /* __FEM_NUMBERING_H__ */
