/*
 * $Id: model.h,v 1.9 2003/08/30 13:32:26 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */


#ifndef __FEM_MODEL_H__
#define __FEM_MODEL_H__


#include <fem/model.h>


/*-----------------------------------------------------------------------------
                                M O D E L _ T 
-----------------------------------------------------------------------------*/

struct model_t;
#include "bc.h"
#include "element.h"
#include "meshing.h"
#include "numbering.h"

typedef struct model_t
{
	const meshing_t		*meshing;
	struct element_t	*element;
	fem_model_type_t	type;
} model_t;


/*-----------------------------------------------------------------------------
                                 M A C R O S 
-----------------------------------------------------------------------------*/

#define MODEL(x)		((model_t *)(x))
#define MODEL_NUMBERING(x)	__fem_numbering_update(			    \
				&MODEL(model)->global,                      \
				MODEL(model)->meshing,                      \
				MODEL(model)->element,                      \
				MODEL(model)->meshing->mesh_list.nb,        \
				MODEL(model)->meshing->node_list.nodes.nb,  \
				&MODEL(model)->bc_list);


#endif /* __FEM_MODEL_H__ */
