/*
 * $Id: matrix.h,v 1.6 2003/09/13 16:49:03 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#ifndef __FEM_MATRIX_H__
#define __FEM_MATRIX_H__

#include <fem/matrix.h>

/*-----------------------------------------------------------------------------
                               M A T R I X _ T 
-----------------------------------------------------------------------------*/

typedef fem_matrix_t matrix_t;


/*-----------------------------------------------------------------------------
                               V E C T O R _ T
-----------------------------------------------------------------------------*/

typedef fem_vector_t vector_t;


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S 
-----------------------------------------------------------------------------*/

extern double **__fem_matrix_new(int row, int col);
extern void __fem_matrix_free(double **matrix, int row);
extern void __fem_matrix_vector(const matrix_t *A, const double *v,
				     double *res);
extern double __fem_vector_norm(const fem_vector_t *vec);


#endif /* __FEM_MATRIX_H__ */
