/*
 * $Id: element_ME1DL2.c,v 1.5 2003/10/05 20:05:40 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */

#include <math.h>

#include <fem.h>

#include "element_ME1DL2.h"

/*-----------------------------------------------------------------------------
                               P R O T O T Y P E S
-----------------------------------------------------------------------------*/

static double j(const double p[], const double *x[]);
static void esm(const fem_element_t *element, double esm[]);


/*-----------------------------------------------------------------------------
                        I M P L E M E N T A T I O N
-----------------------------------------------------------------------------*/

/**
 * Evaluation of Jacobian
 *
 * @param p coordinates of evaluation point
 * @param x the coordinates of nodes
 * @return the jacobian of the element
 */
static double j(const double p[], const double *x[])
{
	(void)p; /* avoid a warning */
	return(x[1][0]-x[0][0]);
}


/**
 * Evaluation of ESM of one element
 *
 * @param element is the considered element
 * @param esm is the computed half-matrix
 */
static void esm(const fem_element_t *element, double esm[])
{
	HAPLO_MATERIAL_REQUEST(element, E);
	HAPLO_PROPERTY_REQUEST(element, S);
	const double l=fabs(element->x[1][0]-element->x[0][0]);

	esm[0] =  E*S/l;
	esm[1] = -E*S/l;
	esm[2] =  E*S/l;

	return;
}


/*-----------------------------------------------------------------------------
                       G L O B A L   V A R I A B L E S 
-----------------------------------------------------------------------------*/

/**
 * Element definition. Internal use only.
 */
fem_element_type_t __fem_element_ME1DL2={
	"ME1DL2",		/* name */
	"DX",			/* dofset */
	2,			/* nb_node */
	1,			/* dim */
	FEM_MODEL_MECANIC,	/* type of model */
	FEM_INTREGRATION_NONE,	/* integration scheme */
	j,			/* computation of jacobian */
	esm,			/* computation of ESM */
	"E",			/* material parameters */
	"S"			/* property parameters */
};
