/*
 * $Id: dof.c,v 1.2 2003/08/30 13:40:29 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */


#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "dof.h"


/*-----------------------------------------------------------------------------
                        G L O B A L   V A R I A B L E 
-----------------------------------------------------------------------------*/

/* A warning at the next line means a serious problem! */
static const char *dof_name[DOF_MAX+1]={
	"DX",
	"DY",
	"DZ",
	"DRX",
	"DRY",
	"DRZ",
	NULL
};


/*-----------------------------------------------------------------------------
                               P R O T O T Y P E S
-----------------------------------------------------------------------------*/

dofset_t __fem_dof_dofset(const char *s);
const char *__fem_dof_name(dofset_t dofset);
dofset_t __fem_dof_nb(const char *name);


/*-----------------------------------------------------------------------------
                        I M P L E M E N T A T I O N
-----------------------------------------------------------------------------*/

/**
 *
 */
dofset_t __fem_dof_dofset(const char *s)
{	
	dofset_t dofset=0;
	size_t len;
	
	do
	{
		const char *off;
		int i;
		
		off=strchr(s, ':');
		
		if (off)
			len=(size_t)(off-s)-1;
		else
			len=strlen(s);

		for(i=0; dof_name[i] != NULL; i++)
			if (strncmp(s, dof_name[i], len) == 0)
			{
				dofset |= ( 1 << i);
				break;
			}
		s=off;
	} while(s);
	
	return(dofset);
}


/**
 *
 */
const char *__fem_dof_name(dofset_t dofnb)
{
	const char *name="[Unamed DOF]";

	if (dofnb < DOF_MAX)
		name = dof_name[dofnb];
	
	return(name);
}


/**
 *
 */
dofset_t __fem_dof_nb(const char *name)
{
	dofset_t dofset=DOF_MAX;
	dofset_t i;
	
	for(i=0; dof_name[i] != NULL; i++)
		if (strcmp(name, dof_name[i]) == 0)
		{
			dofset = i;
			break;
		}
	
	return(dofset);
}
