/*
 * $Id: cara.h,v 1.4 2003/05/20 19:09:03 nicoo Exp $
 *
 *
 * Copyright (C) 1999, 2000, 2001 Nicolas LAURENT
 * This file is part of `Haplo'
 * 
 *
 * `Haplo'  is free software;  you can  redistribute  it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation;  either version 2  of the License, or
 * (at your option) any later version.
 *
 * `Haplo' is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the  implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
 * for more details.
 * 
 * You should have  received  a copy of the   GNU General Public  License
 * along with `Haplo'.  If not, write to  the
 *
 *                                        Free Software Foundation,  Inc.
 *                                        675 Mass Ave, Cambridge, MA
 *                                        02139, USA.
 *
 */


#ifndef __FEM_CARA_H__
#define __FEM_CARA_H__


/*-----------------------------------------------------------------------------
                            C A R A _ M A S K _ T 
-----------------------------------------------------------------------------*/

typedef unsigned long long int cara_mask_t;


/*-----------------------------------------------------------------------------
                            C A R A _ L I S T _ T 
-----------------------------------------------------------------------------*/

typedef struct cara_list_t
{
	unsigned short		nb;		/* number of carateristics */
	double			*values;	/* values of caracteristics */
	cara_mask_t		mask;		/* fixed caracteritics */
	const char *const	*names;		/* names of caracteritics */
} cara_list_t;


/*-----------------------------------------------------------------------------
                                 M A C R O S 
-----------------------------------------------------------------------------*/

#define CARA_GET(c, x)	c->values[x];


/*-----------------------------------------------------------------------------
                             P R O T O T Y P E S 
-----------------------------------------------------------------------------*/

extern cara_list_t __fem_cara_list_new(const char *const *cara);
extern void __fem_cara_list_free(cara_list_t cara_list);
extern cara_list_t __fem_cara_list_copy(const cara_list_t *cara_list);
extern void __fem_cara_list_display(const cara_list_t *cara_list);
extern int __fem_cara_list_set(cara_list_t *cara_list, const char *c,
			       double value);
int __fem_cara_list_unset(cara_list_t *cara_list, const char *c);
extern int __fem_cara_list_get(const cara_list_t *cara_list, const char *c,
			       double *value);
extern int __fem_cara_cmp(const cara_list_t *cara, cara_mask_t data);
extern cara_mask_t __fem_cara_mask(const char *const *names, const char *s);


#endif /* __FEM_CARA_H__ */
